/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.misc.ConsoleInputStream;

public class ShPromptReader
extends Reader {
    private int unread = -1;
    private int lineno = 1;
    private ShEnvironment env;
    private String prompt;
    private boolean isno = false;
    private boolean iseof = false;
    private Reader reader;
    private PrintStream promptout;
    int count = 0;

    public ShPromptReader(ShEnvironment env, PrintStream promptout) {
        this(ConsoleInputStream.console(), Charset.defaultCharset(), env, promptout);
        env.bind("LINENO", Integer.toString(this.lineno));
    }

    public ShPromptReader(InputStream ins, ShEnvironment env, PrintStream promptout) {
        this.env = env;
        this.reader = new InputStreamReader(ins);
        this.promptout = promptout;
        this.promptprint(env.find("PS1"));
        env.bind("LINENO", Integer.toString(this.lineno));
    }

    public ShPromptReader(InputStream ins, Charset encoding, ShEnvironment env, PrintStream promptout) {
        this.env = env;
        this.reader = new InputStreamReader(ins, encoding);
        this.promptout = promptout;
        this.promptprint(env.find("PS1"));
        env.bind("LINENO", Integer.toString(this.lineno));
    }

    public int getLineNumber() {
        return this.lineno;
    }

    public void close() throws IOException {
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int i = off;
        while (i < off + len) {
            int c = this.read();
            if (c < 0) {
                return i - off;
            }
            cbuf[i] = (char)c;
            ++i;
        }
        return len;
    }

    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    private int _read() throws IOException {
        return this.reader.read();
    }

    private void promptprint(String prompt) {
        if (this.promptout != null) {
            this.promptout.print(prompt);
        }
    }

    private void inclineno() {
        this.env.bind("LINENO", Integer.toString(this.lineno++));
    }

    public int read() throws IOException {
        if (this.isno) {
            if (this.count > 0) {
                this.promptprint(this.prompt);
            } else {
                return -1;
            }
        }
        this.isno = false;
        if (this.unread >= 0) {
            int c = this.unread;
            this.unread = -1;
            return c;
        }
        int c = this._read();
        if (c < 0) {
            this.iseof = true;
            return -1;
        }
        if (c == 13) {
            c = this._read();
            if (c >= 0 && c != 10) {
                this.unread = c;
            }
            this.isno = true;
            if (this.count > 0) {
                this.inclineno();
                this.prompt = this.env.find("PS2");
                return c;
            }
            this.inclineno();
            return -1;
        }
        if (c != 10) {
            return c;
        }
        if (this.count > 0) {
            this.inclineno();
            this.prompt = this.env.find("PS2");
            this.isno = true;
            return c;
        }
        this.inclineno();
        this.isno = true;
        return -1;
    }

    public void resetPrompt() {
        this.isno = false;
        this.prompt = this.env.find("PS1");
        this.promptprint(this.prompt);
    }

    public boolean isEof() {
        return this.iseof;
    }
}

