/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShFiles;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShToken;
import net.morilib.sh.ShTree;
import net.morilib.sh.ShTreeExpressionMachine;
import net.morilib.sh.builtin.ShBuiltInCommands;
import net.morilib.sh.misc.XtraceStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShTrees {
    private ShTrees() {
    }

    public static String removeQuote(String s) {
        StringBuffer b = new StringBuffer();
        S1 stat = S1.INIT;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (stat) {
                case INIT: {
                    if (c == '\'') {
                        stat = S1.SQUT;
                        break;
                    }
                    if (c == '\"') {
                        stat = S1.DQUT;
                        break;
                    }
                    if (c == '\\') {
                        stat = S1.ESC1;
                        break;
                    }
                    b.append(c);
                    break;
                }
                case ESC1: {
                    b.append(c);
                    stat = S1.INIT;
                    break;
                }
                case SQUT: {
                    if (c == '\'') {
                        stat = S1.INIT;
                        break;
                    }
                    b.append(c);
                    break;
                }
                case DQUT: {
                    if (c == '\"') {
                        stat = S1.INIT;
                        break;
                    }
                    if (c == '\\') {
                        stat = S1.ESC2;
                        break;
                    }
                    b.append(c);
                    break;
                }
                case ESC2: {
                    b.append(c);
                    stat = S1.DQUT;
                }
            }
            ++i;
        }
        if (stat.equals((Object)S1.ESC1)) {
            b.append('\\');
        }
        return b.toString();
    }

    public static String substituteCase(ShEnvironment env, ShRuntime run, ShFileSystem fs, PrintStream err, XtraceStream p, ShToken line) throws IOException, ShSyntaxException {
        StringBuffer b = new StringBuffer();
        String d = "";
        ArrayList<ShToken> r = new ArrayList<ShToken>();
        r.add(line);
        int i = 0;
        while (i < r.size()) {
            r.set(i, ((ShToken)r.get(i)).replaceTilde(env));
            ++i;
        }
        ArrayList<ShToken> a = new ArrayList<ShToken>();
        i = 0;
        while (i < r.size()) {
            a.addAll(((ShToken)r.get(i)).replaceParameter(env, err));
            ++i;
        }
        r = a;
        i = 0;
        while (i < r.size()) {
            r.set(i, ((ShToken)r.get(i)).replaceCommand(env, fs, run, p));
            ++i;
        }
        i = 0;
        while (i < r.size()) {
            r.set(i, ((ShToken)r.get(i)).replaceArithmetic(env));
            ++i;
        }
        for (ShToken x : r) {
            b.append(d).append(x.toString());
            d = " ";
        }
        return b.toString();
    }

    static List<String> substitute1(ShEnvironment env, ShRuntime run, ShFileSystem fs, PrintStream err, XtraceStream p, ShToken line) throws IOException, ShSyntaxException {
        ArrayList<ShToken> r = new ArrayList<ShToken>(line.replaceBracket());
        int i = 0;
        while (i < r.size()) {
            r.set(i, ((ShToken)r.get(i)).replaceTilde(env));
            ++i;
        }
        ArrayList<ShToken> a = new ArrayList<ShToken>();
        i = 0;
        while (i < r.size()) {
            a.addAll(((ShToken)r.get(i)).replaceParameter(env, err));
            ++i;
        }
        r = a;
        i = 0;
        while (i < r.size()) {
            r.set(i, ((ShToken)r.get(i)).replaceCommand(env, fs, run, p));
            ++i;
        }
        i = 0;
        while (i < r.size()) {
            r.set(i, ((ShToken)r.get(i)).replaceArithmetic(env));
            ++i;
        }
        ArrayList<String> s = new ArrayList<String>();
        i = 0;
        while (i < r.size()) {
            if (((ShToken)r.get(i)).toString().equals("")) {
                s.add("");
            } else {
                s.addAll(((ShToken)r.get(i)).splitWord(env.find("IFS")));
            }
            ++i;
        }
        ArrayList<String> t = new ArrayList<String>();
        i = 0;
        while (i < s.size()) {
            if (!env.isSet("noglob") && ShToken.isWildcard((String)s.get(i))) {
                List<ShFile> f = ShFiles.glob((String)s.get(i), fs);
                if (f.isEmpty()) {
                    t.add(ShTrees.removeQuote((String)s.get(i)));
                } else {
                    for (ShFile x : f) {
                        t.add(x.getName());
                    }
                }
            } else {
                t.add(ShTrees.removeQuote((String)s.get(i)));
            }
            ++i;
        }
        return t;
    }

    public static String substitute(ShEnvironment env, ShRuntime run, ShFileSystem fs, PrintStream err, XtraceStream p, ShToken token) throws IOException, ShSyntaxException {
        List<String> l = ShTrees.substitute1(env, run, fs, err, p, token);
        StringBuffer b = new StringBuffer();
        String d = "";
        for (String s : l) {
            b.append(d).append(s);
            d = " ";
        }
        return b.toString();
    }

    public static List<String> substitute(ShEnvironment env, ShRuntime run, ShFileSystem fs, PrintStream err, XtraceStream p, List<ShToken> line) throws IOException, ShSyntaxException {
        ArrayList<String> f = new ArrayList<String>();
        for (ShToken t : line) {
            f.addAll(ShTrees.substitute1(env, run, fs, err, p, t));
        }
        return f;
    }

    public static List<String> substituteCommand(ShEnvironment env, ShBuiltInCommands cmd, ShRuntime run, ShFileSystem fs, PrintStream err, XtraceStream p, List<ShToken> line) throws IOException, ShSyntaxException {
        ArrayList<String> f = new ArrayList<String>();
        for (ShToken t : line) {
            f.addAll(ShTrees.substitute1(env, run, fs, err, p, t));
        }
        return f;
    }

    public static ShTree compile(ShTree t) {
        ShTreeExpressionMachine.Builder b = new ShTreeExpressionMachine.Builder();
        t.compileInternally(b, null, null);
        return b.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum S1 {
        INIT,
        ESC1,
        SQUT,
        DQUT,
        ESC2;

    }
}

