/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.builtin;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.sh.ShSignal;

public class ShTrap
implements ShProcess {
    public int main(ShEnvironment env, ShFileSystem fs, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
        int k = 1;
        if (args.length < 2) {
            err.println("trap: too few arguments.");
            return 2;
        }
        if (args[k].equals("-p")) {
            for (ShSignal x : ShSignal.getAll()) {
                out.print("trap -- '");
                out.print(env.getTrap(x));
                out.print("' ");
                out.println((Object)x);
            }
            return 0;
        }
        if (args[k].equals("--")) {
            ++k;
        }
        if (args.length - k < 2) {
            err.println("trap: too few arguments.");
            return 2;
        }
        ShSignal s = ShSignal.getInstance(args[k + 1]);
        if (s == null) {
            err.print("trap: invalid signal: ");
            err.println(args[k + 1]);
            return 2;
        }
        if (args[k].equals("")) {
            env.setTrap(s, null);
            return 0;
        }
        env.setTrap(s, args[k]);
        return 0;
    }
}

