/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.builtin;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

public class ShWc
implements ShProcess {
    private static final int BYTES = 1;
    private static final int CHARS = 2;
    private static final int WORDS = 4;
    private static final int LINES = 8;

    private int analyzeopt(String s, int[] f) {
        int i = 1;
        while (i < s.length()) {
            switch (s.charAt(i)) {
                case 'c': {
                    f[0] = f[0] | 1;
                    break;
                }
                case 'm': {
                    f[0] = f[0] | 2;
                    break;
                }
                case 'w': {
                    f[0] = f[0] | 4;
                    break;
                }
                case 'l': {
                    f[0] = f[0] | 8;
                    break;
                }
                default: {
                    return s.charAt(i);
                }
            }
            ++i;
        }
        return -1;
    }

    private void prt(PrintStream out, int f, String name, long l, long w, long c, long b) {
        String d = "";
        if (f == 0) {
            if (name == null) {
                out.format("%7d %7d %7d\n", l, w, b);
            } else {
                out.format("%7d %7d %7d %s\n", l, w, b, name);
            }
        } else {
            if ((f & 8) != 0) {
                out.format("%s%7d", d, l);
                d = " ";
            }
            if ((f & 4) != 0) {
                out.format("%s%7d", d, w);
                d = " ";
            }
            if ((f & 2) != 0) {
                out.format("%s%7d", d, c);
                d = " ";
            }
            if ((f & 1) != 0) {
                out.format("%s%7d", d, b);
                d = " ";
            }
            if (name != null) {
                out.format("%s%s", d, name);
            }
            out.println();
        }
    }

    private void wc(InputStream ins, PrintStream out, String name, int f, long[] sum, Charset cset) throws IOException {
        int x;
        long l;
        boolean wd = false;
        boolean cr = false;
        boolean lf = true;
        ByteBuffer bb = ByteBuffer.allocate(8);
        CharBuffer cb = CharBuffer.allocate(8);
        CharsetDecoder cd = cset.newDecoder();
        byte[] a = new byte[8];
        int y = 0;
        int k = 0;
        long w = l = (long)0;
        long c = l;
        long b = l;
        while ((x = ins.read()) >= 0) {
            a[k] = (byte)x;
            bb.put(a, 0, k + 1).flip();
            if (cd.decode(bb, cb, true).isUnderflow()) {
                cd.flush(cb);
                if (cb.flip().hasRemaining()) {
                    y = cb.get();
                    ++c;
                }
                cb.clear();
                cd.reset();
                k = 0;
            } else {
                y = -1;
                ++k;
            }
            bb.clear();
            if (wd) {
                wd = y < 0 || !Character.isWhitespace(y);
            } else {
                wd = !Character.isWhitespace(y);
                if (wd) {
                    ++w;
                }
            }
            lf = y == 10;
            l += (long)(lf || cr ? 1 : 0);
            cr = y == 13;
            ++b;
        }
        this.prt(out, f, name, l += (long)(lf ? 0 : 1), w, c, b);
        if (sum != null) {
            sum[0] = sum[0] + l;
            sum[1] = sum[1] + w;
            sum[2] = sum[2] + c;
            sum[3] = sum[3] + b;
        }
    }

    public int main(ShEnvironment env, ShFileSystem fs, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
        InputStream ins = null;
        int[] f = new int[1];
        int k = 1;
        int l = 0;
        while (k < args.length) {
            if (args[k].equals("--bytes")) {
                f[0] = f[0] | 1;
            } else if (args[k].equals("--chars")) {
                f[0] = f[0] | 2;
            } else if (args[k].equals("--words")) {
                f[0] = f[0] | 4;
            } else if (args[k].equals("--lines")) {
                f[0] = f[0] | 8;
            } else {
                if (args[k].equals("--")) {
                    ++k;
                    break;
                }
                if (args[k].equals("-") || !args[k].startsWith("-")) break;
                int z = this.analyzeopt(args[k], f);
                if (z >= 0) {
                    err.println("wc: invalid option: " + (char)z);
                    return 2;
                }
            }
            ++k;
        }
        if (k >= args.length) {
            this.wc(in, out, null, f[0], null, env.getCharset());
        } else {
            long[] s = new long[4];
            s[3] = 0L;
            s[2] = 0L;
            s[1] = 0L;
            s[0] = 0L;
            while (k < args.length) {
                if (args[k].equals("-")) {
                    this.wc(in, out, "(standard input)", f[0], s, env.getCharset());
                } else {
                    try {
                        ins = fs.getFile(args[k]).getInputStream();
                        if (ins == null) {
                            err.print("wc: ");
                            err.print(args[k]);
                            err.println(": file not found");
                            return 2;
                        }
                        this.wc(ins, out, args[k], f[0], s, env.getCharset());
                    }
                    finally {
                        if (ins != null) {
                            ins.close();
                        }
                        ins = null;
                    }
                }
                ++k;
                ++l;
            }
            if (l > 1) {
                this.prt(out, f[0], "(total)", s[0], s[1], s[2], s[3]);
            }
        }
        return 0;
    }
}

