/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.unix.misc;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ParseDate {
    private static final Pattern TIM_01 = Pattern.compile("([0-9]+):([0-9]+)(:([0-9]+))?");
    private static final Pattern PTN_01 = Pattern.compile("([0-9][0-9][0-9][0-9]+)[\\-/.\u5e74\ub144]([0-9]+)[\\-/.\u6708\uc6d4]([0-9]+)[\u65e5\uc77c]?( +([0-9]+:[0-9]+(:[0-9]+)?))?");
    private static final Pattern PTN_02 = Pattern.compile("([0-9][0-9]?)/([0-9][0-9]?)/([0-9]+)( +([0-9]+:[0-9]+(:[0-9]+)?))?");
    private static final Pattern PTN_03 = Pattern.compile("([0-9][0-9]?)\\.([0-9][0-9]?)\\.([0-9]+)( +([0-9]+:[0-9]+(:[0-9]+)?))?");
    private static final Pattern PTN_04 = Pattern.compile("([0-9][0-9][0-9][0-9])([0-9][0-9])([0-9][0-9])( +([0-9]+:[0-9]+(:[0-9]+)?))?");
    private static final Pattern PTNJA01 = Pattern.compile("(\u660e\u6cbb?|\u5927\u6b63?|\u662d\u548c?|\u5e73\u6210?|[MTSH])([0-9]+)[\\-\u5e74]([0-9]+)[\\-\u6708]([0-9]+)\u65e5?( +([0-9]+:[0-9]+(:[0-9]+)?))?");
    private static final Pattern PTNJA02 = Pattern.compile("(\u660e\u6cbb?|\u5927\u6b63?|\u662d\u548c?|\u5e73\u6210?|[MTSH])([0-9][0-9])([0-9][0-9])([0-9][0-9])( +([0-9]+:[0-9]+(:[0-9]+)?))?");
    private static final Pattern PTNCJK2 = Pattern.compile("([0-9]+)[\u6708\uc6d4]([0-9]+)[\u65e5\uc77c]");
    private static final Pattern PTNEN01 = Pattern.compile("(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) +([0-9]+)( +|, *)([0-9]+)( +([0-9]+:[0-9]+(:[0-9]+)?))?");
    private static final Pattern PTNEN02 = Pattern.compile("(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)[a-z]* +([0-9]+)");
    private static final Pattern PTNEN03 = Pattern.compile("(([0-9]+) +years?)? *(([0-9]+) +months?)? *(([0-9]+) +days?)? *( +ago)?");
    private static final Pattern PTNFR01 = Pattern.compile("([0-9]+) +(janv\\.|f[\u00e9e]vr\\.|mars|avr\\.|mai|juin|juil\\.|ao[\u00fbu]t|sept\\.|oct\\.|nov\\.|d[\u00e9e]c\\.) +([0-9]+)( +([0-9]+:[0-9]+(:[0-9]+)?))?");
    private static final Pattern PTNFR02 = Pattern.compile("([0-9]+) +(janv\\.|janvier|f[\u00e9e]vr\\.|f[\u00e9e]vrier|mars|avr\\.|avril|mai|juin|juil\\.|juilet|ao[\u00fbu]t|sept\\.|septembre|oct\\.|octobre|nov\\.|novembre|d[\u00e9e]c\\.|d[\u00e9e]cembre)");
    private static final Pattern PTNIT01 = Pattern.compile("([0-9]+)-(gen|feb|mar|apr|mag|giu|lug|ago|set|ott|nov|dic)-([0-9]+)( +([0-9]+:[0-9]+(:[0-9]+)?))?");
    private static final Pattern PTNIT02 = Pattern.compile("([0-9]+) +(gen|feb|mar|apr|mag|giu|lug|ago|set|ott|nov|dic)");
    private static final Pattern PTNES01 = Pattern.compile("([0-9]+)-(ene|feb|mar|abr|may|jun|jul|ago|sep|oct|nov|dic)-([0-9]+)( +([0-9]+:[0-9]+(:[0-9]+)?))?");
    private static final Pattern PTNES02 = Pattern.compile("([0-9]+) +de +(ene|feb|mar|abr|may|jun|jul|ago|sep|oct|nov|dic)");
    private static final Pattern PTNPT01 = Pattern.compile("([0-9]+)/(Jan|Fev|Mar|Abr|Mai|Jun|Jul|Ago|Set|Out|Nov|Dez)/([0-9]+)( +([0-9]+:[0-9]+(:[0-9]+)?))?");
    private static final Pattern PTNPT02 = Pattern.compile("([0-9]+) +de +(jan|fev|mar|abr|mai|jun|jul|ago|set|out|nov|dez)");
    private static final Pattern PTNNL01 = Pattern.compile("([0-9]+)-(jan|feb|mrt|apr|mei|jun|jul|aug|sep|okt|nov|dec)-([0-9]+)( +([0-9]+:[0-9]+(:[0-9]+)?))?");
    private static final Pattern PTNNL02 = Pattern.compile("([0-9]+) +(jan|feb|mrt|apr|mei|jun|jul|aug|sep|okt|nov|dec)");
    private static final Pattern PTNDE02 = Pattern.compile("([0-9]+) +(Jan|Feb|M[a\u00e4]r|Apr|Mai|Jun|Jul|Aug|Sep|Okt|Nov|Dez)");
    private static final Pattern PTNRU02 = Pattern.compile("([0-9]+) +(\u042f\u043d\u0432|\u0424\u0435\u0432|\u041c\u0430\u0440|\u0410\u043f\u0440|\u041c\u0430\u0439|\u0418\u044e\u043d|\u0418\u044e\u043d|\u0410\u0432\u0433|\u0421\u0435\u043d|\u041e\u043a\u0442|\u041d\u043e\u044f|\u0414\u0435\u043a)");
    private static final Pattern PTN1 = Pattern.compile("([0-9][0-9])([0-9][0-9])([0-9][0-9])([0-9][0-9])((([0-9][0-9])?[0-9][0-9])?)(\\.([0-9][0-9])?)?");
    private static final String[][] MONTHS = new String[][]{{"Jan", "janv.", "janv.", "janvier", "janvier", "gen", "ene", "Ene", "Jan", "jan", "jan", "Januari", "Jan", "Jan", "\u042f\u043d\u0432"}, {"Feb", "fevr.", "f\u00e9vr.", "fevrier", "f\u00e9vrier", "feb", "feb", "Feb", "Fev", "fev", "feb", "Februari", "Feb", "Feb", "\u0424\u0435\u0432"}, {"Mar", "mars", "mars", "mars", "mars", "mar", "mar", "Mar", "Mar", "mar", "mrt", "Maart", "Mar", "M\u00e4r", "\u041c\u0430\u0440"}, {"Apr", "avr.", "avr.", "avril", "avril", "apr", "abr", "Abr", "Abr", "abr", "apr", "April", "Apr", "Apr", "\u0410\u043f\u0440"}, {"May", "mai", "mai", "mai", "mai", "mag", "may", "May", "Mai", "mai", "mei", "Mei", "Mai", "Mai", "\u041c\u0430\u0439"}, {"Jun", "juin", "juin", "juin", "juin", "giu", "jun", "Jun", "Jun", "jun", "jun", "Juni", "Jun", "Jun", "\u0418\u044e\u043d"}, {"Jul", "juil.", "juil.", "juilet", "juilet", "lug", "jul", "Jul", "Jul", "jul", "jul", "Juli", "Jul", "Jul", "\u0418\u044e\u043b"}, {"Aug", "aout", "ao\u00fbt", "aout", "ao\u00fbt", "ago", "ago", "Ago", "Ago", "ago", "aug", "Augustus", "Aug", "Aug", "\u0410\u0432\u0433"}, {"Sep", "sept.", "sept.", "septembre", "septembre", "set", "sep", "Sep", "Set", "set", "sep", "September", "Sep", "Sep", "\u0421\u0435\u043d"}, {"Oct", "oct.", "oct.", "octobre", "octobre", "ott", "oct", "Oct", "Out", "out", "okt", "Oktober", "Okt", "Okt", "\u041e\u043a\u0442"}, {"Nov", "nov.", "nov.", "novembre", "novembre", "nov", "nov", "Nov", "Nov", "nov", "nov", "November", "Nov", "Nov", "\u041d\u043e\u044f"}, {"Dec", "dec.", "d\u00e9c.", "decembre", "d\u00e9cembre", "dic", "dic", "Dic", "Dez", "dez", "dec", "December", "Dez", "Dez", "\u0414\u0435\u043a"}};

    private static int getMonth(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        int i = 0;
        while (i < MONTHS.length) {
            int j = 0;
            while (j < MONTHS[i].length) {
                if (s.startsWith(MONTHS[i][j])) {
                    return i + 1;
                }
                ++j;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    public static Long parseTime(String str) {
        long se;
        Matcher m = TIM_01.matcher(str);
        if (!m.matches()) {
            return null;
        }
        long ho = Long.parseLong(m.group(1));
        long mi = Long.parseLong(m.group(2));
        long l = se = m.group(3) != null ? Long.parseLong(m.group(4)) : 0L;
        if (ho > 23L) {
            throw new IllegalArgumentException();
        }
        if (mi > 59L) {
            throw new IllegalArgumentException();
        }
        if (se > 60L) {
            throw new IllegalArgumentException();
        }
        return ((ho * 60L + mi) * 60L + se) * 1000L;
    }

    private static Long fromMD(Pattern p, String str) {
        Matcher m = p.matcher(str);
        if (!m.lookingAt()) {
            return null;
        }
        GregorianCalendar cl = new GregorianCalendar();
        int ye = cl.get(1);
        int mo = ParseDate.getMonth(m.group(1));
        int da = Integer.parseInt(m.group(2));
        long ti = 0L;
        cl = new GregorianCalendar(ye, mo - 1, da);
        return cl.getTimeInMillis() + ti;
    }

    private static Long fromDM(Pattern p, String str) {
        Matcher m = p.matcher(str);
        if (!m.lookingAt()) {
            return null;
        }
        GregorianCalendar cl = new GregorianCalendar();
        int ye = cl.get(1);
        int mo = ParseDate.getMonth(m.group(2));
        int da = Integer.parseInt(m.group(1));
        long ti = 0L;
        cl = new GregorianCalendar(ye, mo - 1, da);
        return cl.getTimeInMillis() + ti;
    }

    private static Long fromMDCJK(String str) {
        Matcher m = PTNCJK2.matcher(str);
        if (!m.lookingAt()) {
            return null;
        }
        GregorianCalendar cl = new GregorianCalendar();
        int ye = cl.get(1);
        int mo = Integer.parseInt(m.group(1));
        int da = Integer.parseInt(m.group(2));
        long ti = 0L;
        cl = new GregorianCalendar(ye, mo - 1, da);
        return cl.getTimeInMillis() + ti;
    }

    private static Long fromDf(Date t, Pattern p, String str) {
        int da;
        Matcher m = p.matcher(str);
        if (!m.matches()) {
            return null;
        }
        if (m.group(2) == null && m.group(4) == null && m.group(6) == null) {
            return null;
        }
        GregorianCalendar cl = new GregorianCalendar();
        cl.setTime(t);
        int ye = m.group(2) != null ? Integer.parseInt(m.group(2)) : 0;
        int mo = m.group(4) != null ? Integer.parseInt(m.group(4)) : 0;
        int n = da = m.group(6) != null ? Integer.parseInt(m.group(6)) : 0;
        if (m.group(7) == null || m.group(7).equals("")) {
            cl.add(1, ye);
            cl.add(2, mo);
            cl.add(6, da);
        } else {
            cl.add(1, -ye);
            cl.add(2, -mo);
            cl.add(6, -da);
        }
        return cl.getTimeInMillis();
    }

    public static long from(Date time, String str) {
        Long r = ParseDate.fromStandard(str);
        if (r != null || (r = ParseDate.fromJapanese(str)) != null || (r = ParseDate.fromEnglish(str)) != null || (r = ParseDate.fromFrench(str)) != null || (r = ParseDate.fromItaly(str)) != null || (r = ParseDate.fromSpanish(str)) != null || (r = ParseDate.fromPortuguese(str)) != null || (r = ParseDate.fromDutch(str)) != null || (r = ParseDate.fromMDCJK(str)) != null || (r = ParseDate.fromMD(PTNEN02, str)) != null || (r = ParseDate.fromDM(PTNFR02, str)) != null || (r = ParseDate.fromDM(PTNIT02, str)) != null || (r = ParseDate.fromDM(PTNES02, str)) != null || (r = ParseDate.fromDM(PTNPT02, str)) != null || (r = ParseDate.fromDM(PTNNL02, str)) != null || (r = ParseDate.fromDM(PTNDE02, str)) != null || (r = ParseDate.fromDM(PTNRU02, str)) != null || (r = ParseDate.fromDf(time, PTNEN03, str)) != null) {
            return r;
        }
        throw new IllegalArgumentException();
    }

    public static Long fromStandard(String str) {
        long ti;
        int da;
        int mo;
        int ye;
        Matcher m = PTN_01.matcher(str);
        if (m.matches()) {
            ye = Integer.parseInt(m.group(1));
            mo = Integer.parseInt(m.group(2));
            da = Integer.parseInt(m.group(3));
            ti = m.group(4) != null ? ParseDate.parseTime(m.group(5)) : 0L;
        } else {
            m = PTN_02.matcher(str);
            if (m.matches()) {
                ye = Integer.parseInt(m.group(3));
                mo = Integer.parseInt(m.group(1));
                da = Integer.parseInt(m.group(2));
                ti = m.group(4) != null ? ParseDate.parseTime(m.group(5)) : 0L;
            } else {
                m = PTN_03.matcher(str);
                if (m.matches()) {
                    ye = Integer.parseInt(m.group(3));
                    mo = Integer.parseInt(m.group(2));
                    da = Integer.parseInt(m.group(1));
                    ti = m.group(4) != null ? ParseDate.parseTime(m.group(5)) : 0L;
                } else {
                    m = PTN_04.matcher(str);
                    if (m.matches()) {
                        ye = Integer.parseInt(m.group(1));
                        mo = Integer.parseInt(m.group(2));
                        da = Integer.parseInt(m.group(3));
                        ti = m.group(4) != null ? ParseDate.parseTime(m.group(5)) : 0L;
                    } else {
                        return null;
                    }
                }
            }
        }
        GregorianCalendar cl = new GregorianCalendar(ye, mo - 1, da);
        return cl.getTimeInMillis() + ti;
    }

    public static Long fromEnglish(String str) {
        Matcher m = PTNEN01.matcher(str);
        if (!m.matches()) {
            return null;
        }
        int ye = Integer.parseInt(m.group(4));
        int mo = ParseDate.getMonth(m.group(1));
        int da = Integer.parseInt(m.group(2));
        long ti = m.group(5) != null ? ParseDate.parseTime(m.group(6)) : 0L;
        GregorianCalendar cl = new GregorianCalendar(ye, mo - 1, da);
        return cl.getTimeInMillis() + ti;
    }

    private static int getGengoEpoch(String str) {
        if (str.equals("M") || str.startsWith("\u660e")) {
            return 1868;
        }
        if (str.equals("T") || str.startsWith("\u5927")) {
            return 1912;
        }
        if (str.equals("S") || str.startsWith("\u662d")) {
            return 1926;
        }
        if (str.equals("H") || str.startsWith("\u5e73")) {
            return 1989;
        }
        throw new IllegalArgumentException();
    }

    public static Long fromJapanese(String str) {
        Matcher m = PTNJA01.matcher(str);
        if (m.matches() || (m = PTNJA02.matcher(str)).matches()) {
            int ye = ParseDate.getGengoEpoch(m.group(1)) - 1;
            int mo = Integer.parseInt(m.group(3));
            int da = Integer.parseInt(m.group(4));
            long ti = m.group(5) != null ? ParseDate.parseTime(m.group(6)) : 0L;
            GregorianCalendar cl = new GregorianCalendar(ye += Integer.parseInt(m.group(2)), mo - 1, da);
            return cl.getTimeInMillis() + ti;
        }
        return null;
    }

    private static Long fromDMY(Pattern p, String str) {
        Matcher m = p.matcher(str);
        if (!m.matches()) {
            return null;
        }
        int ye = Integer.parseInt(m.group(3));
        int mo = ParseDate.getMonth(m.group(2));
        int da = Integer.parseInt(m.group(1));
        long ti = m.group(4) != null ? ParseDate.parseTime(m.group(5)) : 0L;
        GregorianCalendar cl = new GregorianCalendar(ye, mo - 1, da);
        return cl.getTimeInMillis() + ti;
    }

    public static Long fromFrench(String str) {
        return ParseDate.fromDMY(PTNFR01, str);
    }

    public static Long fromItaly(String str) {
        return ParseDate.fromDMY(PTNIT01, str);
    }

    public static Long fromSpanish(String str) {
        return ParseDate.fromDMY(PTNES01, str);
    }

    public static Long fromPortuguese(String str) {
        return ParseDate.fromDMY(PTNPT01, str);
    }

    public static Long fromDutch(String str) {
        return ParseDate.fromDMY(PTNNL01, str);
    }

    public static Date parseMMDD(String str) {
        Matcher m = PTN1.matcher(str);
        if (m.matches()) {
            int ye;
            GregorianCalendar cl;
            int mo = Integer.parseInt(m.group(1)) - 1;
            int da = Integer.parseInt(m.group(2));
            int ho = Integer.parseInt(m.group(3));
            int mi = Integer.parseInt(m.group(4));
            if (m.group(5) == null || m.group(5).equals("")) {
                cl = new GregorianCalendar();
                ye = cl.get(1);
            } else if (m.group(5).length() == 2) {
                cl = new GregorianCalendar();
                ye = cl.get(1) / 100;
                ye = ye * 100 + Integer.parseInt(m.group(5));
            } else {
                ye = Integer.parseInt(m.group(5));
            }
            int se = m.group(9) != null ? Integer.parseInt(m.group(9)) : 0;
            cl = new GregorianCalendar(ye, mo, da, ho, mi, se);
            return cl.getTime();
        }
        return null;
    }
}

