/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.io;

import java.io.IOException;
import java.sql.SQLException;
import net.morilib.awk.AwkCastException;
import net.morilib.awk.AwkSQLException;
import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkSQLCloseable;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkValue;

public class AwkClose
extends AwkExpression {
    private AwkExpression file;

    public AwkClose(AwkExpression file) {
        this.file = file;
    }

    public AwkValue eval(AwkNamespace ns, AwkFiles o) {
        try {
            AwkValue v = this.file.eval(ns, o);
            if (v.isString()) {
                o.close(v.toString(ns));
            } else if (v instanceof AwkSQLCloseable) {
                ((AwkSQLCloseable)((Object)v)).closeSQL();
            } else {
                throw new AwkCastException("string required");
            }
            return AwkValue.TRUE;
        }
        catch (IOException e) {
            ns.getRoot().assign("ERRNO", AwkString.valueOf(e.getMessage()));
            return AwkValue.FALSE;
        }
        catch (SQLException e) {
            throw new AwkSQLException(e);
        }
    }
}

