/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.matrix;

import net.morilib.awk.matrix.ArrayDoubleMatrix;
import net.morilib.awk.matrix.ArrayDoubleVector;
import net.morilib.awk.matrix.AwkMatrixException;
import net.morilib.awk.matrix.DoubleMatrices;
import net.morilib.awk.matrix.DoubleMatrix;
import net.morilib.awk.matrix.DoubleVector;
import net.morilib.awk.matrix.Permutation;

public abstract class AbstractDoubleMatrix
implements DoubleMatrix {
    public DoubleVector getRowVector(int row) {
        double[] r = new double[this.columnSize()];
        if (row < 0 || row >= this.rowSize()) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < this.columnSize()) {
            r[i] = this.get(row, i);
            ++i;
        }
        return new ArrayDoubleVector(r);
    }

    public DoubleVector getColumnVector(int column) {
        double[] ra = new double[this.columnSize()];
        if (column < 0 || column >= this.columnSize()) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < this.rowSize()) {
            ra[i] = this.get(i, column);
            ++i;
        }
        return new ArrayDoubleVector(ra);
    }

    public DoubleMatrix transpose() {
        ArrayDoubleMatrix r = new ArrayDoubleMatrix(this);
        int i = 0;
        while (i < this.rowSize()) {
            int j = 0;
            while (j < this.columnSize()) {
                r.set(j, i, this.get(i, j));
                ++j;
            }
            ++i;
        }
        return r;
    }

    public DoubleMatrix add(DoubleMatrix a) throws AwkMatrixException {
        if (this.rowSize() != a.rowSize() || this.columnSize() != a.columnSize()) {
            throw new AwkMatrixException("cannot add the given matrix");
        }
        ArrayDoubleMatrix r = new ArrayDoubleMatrix(this);
        int i = 0;
        while (i < this.rowSize()) {
            int j = 0;
            while (j < this.columnSize()) {
                r.set(i, j, r.get(i, j) + a.get(i, j));
                ++j;
            }
            ++i;
        }
        return r;
    }

    public DoubleMatrix sub(DoubleMatrix a) throws AwkMatrixException {
        if (this.rowSize() != a.rowSize() || this.columnSize() != a.columnSize()) {
            throw new AwkMatrixException("cannot subtract the given matrix");
        }
        ArrayDoubleMatrix r = new ArrayDoubleMatrix(this);
        int i = 0;
        while (i < this.rowSize()) {
            int j = 0;
            while (j < this.columnSize()) {
                r.set(i, j, r.get(i, j) - a.get(i, j));
                ++j;
            }
            ++i;
        }
        return r;
    }

    public DoubleVector mul(DoubleVector a) throws AwkMatrixException {
        if (this.rowSize() != a.size()) {
            throw new AwkMatrixException("cannot multiply the given matrix");
        }
        ArrayDoubleVector v = new ArrayDoubleVector(this.columnSize());
        int i = 0;
        while (i < this.columnSize()) {
            double x = 0.0;
            int k = 0;
            while (k < this.rowSize()) {
                x += this.get(k, i) * a.get(k);
                ++k;
            }
            v.set(i, x);
            ++i;
        }
        return v;
    }

    public DoubleMatrix mul(double a) {
        ArrayDoubleMatrix r = new ArrayDoubleMatrix(this);
        int i = 0;
        while (i < this.rowSize()) {
            int j = 0;
            while (j < this.columnSize()) {
                r.set(i, j, r.get(i, j) * a);
                ++j;
            }
            ++i;
        }
        return r;
    }

    public DoubleMatrix uminus() {
        ArrayDoubleMatrix r = new ArrayDoubleMatrix(this);
        int i = 0;
        while (i < this.rowSize()) {
            int j = 0;
            while (j < this.columnSize()) {
                r.set(i, j, -r.get(i, j));
                ++j;
            }
            ++i;
        }
        return r;
    }

    public DoubleMatrix mul(DoubleMatrix a) throws AwkMatrixException {
        if (this.columnSize() != a.rowSize()) {
            throw new AwkMatrixException("cannot multiply the given matrix");
        }
        ArrayDoubleMatrix m = new ArrayDoubleMatrix(this.rowSize(), a.columnSize());
        int i = 0;
        while (i < this.rowSize()) {
            int j = 0;
            while (j < a.columnSize()) {
                double x = 0.0;
                int k = 0;
                while (k < this.columnSize()) {
                    x += this.get(i, k) * a.get(k, j);
                    ++k;
                }
                m.set(i, j, x);
                ++j;
            }
            ++i;
        }
        return m;
    }

    public double determinant() throws AwkMatrixException {
        if (this.columnSize() != this.rowSize()) {
            throw new AwkMatrixException("square matrix required");
        }
        DoubleMatrix[] dc = DoubleMatrices.decomposeLU(this);
        return dc[0].determinant() * dc[2].determinant();
    }

    public DoubleMatrix inv() throws AwkMatrixException {
        if (this.columnSize() != this.rowSize()) {
            throw new AwkMatrixException("square matrix required");
        }
        DoubleMatrix[] decomposed = DoubleMatrices.decomposeLU(this);
        DoubleMatrix x = decomposed[2].inv();
        DoubleMatrix y = decomposed[1].inv();
        x = x.mul(y);
        y = decomposed[0].inv();
        x = x.mul(y);
        return x;
    }

    public DoubleMatrix changeRow(final Permutation rowp) {
        if (rowp.size() != this.rowSize()) {
            throw new IllegalArgumentException();
        }
        return new AbstractDoubleMatrix(){

            public double get(int row, int column) {
                return AbstractDoubleMatrix.this.get(rowp.get(row), column);
            }

            public void set(int row, int column, double x) throws AwkMatrixException {
                AbstractDoubleMatrix.this.set(rowp.get(row), column, x);
            }

            public int rowSize() {
                return AbstractDoubleMatrix.this.rowSize();
            }

            public int columnSize() {
                return AbstractDoubleMatrix.this.columnSize();
            }
        };
    }

    public DoubleMatrix changeColumn(final Permutation colp) {
        if (colp.size() != this.columnSize()) {
            throw new IllegalArgumentException();
        }
        return new AbstractDoubleMatrix(){

            public double get(int row, int column) {
                return AbstractDoubleMatrix.this.get(row, colp.get(column));
            }

            public void set(int row, int column, double x) throws AwkMatrixException {
                AbstractDoubleMatrix.this.set(row, colp.get(column), x);
            }

            public int rowSize() {
                return AbstractDoubleMatrix.this.rowSize();
            }

            public int columnSize() {
                return AbstractDoubleMatrix.this.columnSize();
            }
        };
    }

    public DoubleMatrix submatrix(final int rowb, final int rowe, final int colb, final int cole) {
        if (rowb < 0 || rowb >= this.rowSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (rowe < 0 || rowe >= this.rowSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (colb < 0 || colb >= this.columnSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (cole < 0 || cole >= this.columnSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (rowe <= rowb) {
            throw new IllegalArgumentException();
        }
        if (cole <= colb) {
            throw new IllegalArgumentException();
        }
        return new AbstractDoubleMatrix(){

            public double get(int row, int column) {
                if (row < 0 || row >= rowe - rowb) {
                    throw new IndexOutOfBoundsException();
                }
                if (column < 0 || column >= cole - colb) {
                    throw new IndexOutOfBoundsException();
                }
                return AbstractDoubleMatrix.this.get(row + rowb, column + colb);
            }

            public void set(int row, int column, double x) throws AwkMatrixException {
                if (row < 0 || row >= rowe - rowb) {
                    throw new IndexOutOfBoundsException();
                }
                if (column < 0 || column >= cole - colb) {
                    throw new IndexOutOfBoundsException();
                }
                AbstractDoubleMatrix.this.set(row + rowb, column + colb, x);
            }

            public int rowSize() {
                return rowe - rowb;
            }

            public int columnSize() {
                return cole - colb;
            }
        };
    }

    public DoubleMatrix submatrix(final int[] rowa, final int[] cola) throws AwkMatrixException {
        int i = 0;
        while (i < rowa.length) {
            if (rowa[i] >= this.rowSize()) {
                throw new AwkMatrixException("invaild range");
            }
            ++i;
        }
        i = 0;
        while (i < cola.length) {
            if (cola[i] >= this.columnSize()) {
                throw new AwkMatrixException("invalid range");
            }
            ++i;
        }
        return new AbstractDoubleMatrix(){

            public double get(int row, int column) {
                return AbstractDoubleMatrix.this.get(rowa[row], cola[column]);
            }

            public void set(int row, int column, double x) throws AwkMatrixException {
                AbstractDoubleMatrix.this.set(rowa[row], cola[column], x);
            }

            public int rowSize() {
                return rowa.length;
            }

            public int columnSize() {
                return cola.length;
            }
        };
    }

    public boolean isEqualTo(DoubleMatrix y) {
        if (this.rowSize() != y.rowSize() || this.columnSize() != y.columnSize()) {
            return false;
        }
        int i = 0;
        while (i < this.rowSize()) {
            int j = 0;
            while (j < this.columnSize()) {
                if (this.get(i, j) != y.get(i, j)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean isSquare() {
        return this.rowSize() == this.columnSize();
    }
}

