/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.misc;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import net.morilib.sh.ShFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesReader
extends Reader {
    private Reader reader = null;
    private List<Object> files;
    private boolean resource = false;

    FilesReader(boolean resource, List<Object> files) {
        this.files = new LinkedList<Object>(files);
        this.resource = resource;
    }

    public static FilesReader newFiles(List<Object> files) {
        return new FilesReader(false, files);
    }

    public static FilesReader newResorces(List<Object> files) {
        return new FilesReader(true, files);
    }

    boolean setreader() throws IOException {
        if (this.reader != null) {
            return true;
        }
        if (this.files == null) {
            return false;
        }
        if (this.files.size() == 0) {
            this.files = null;
            return false;
        }
        this.reader = this.files.get(0) instanceof ShFile ? new InputStreamReader(((ShFile)this.files.remove(0)).getInputStream()) : (this.resource ? new InputStreamReader(FilesReader.class.getResourceAsStream(this.files.remove(0).toString())) : new StringReader(this.files.remove(0).toString()));
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = null;
        this.files = null;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.setreader()) {
            int c;
            while ((c = this.reader.read()) < 0) {
                this.reader.close();
                this.reader = null;
                if (!this.setreader()) break;
            }
            return c;
        }
        return -1;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public boolean ready() throws IOException {
        return this.reader.ready();
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.setreader()) {
            long m;
            for (long l = n; (m = this.reader.skip(l)) < l; l -= m) {
                this.reader.close();
                this.reader = null;
                if (this.setreader()) {
                    continue;
                }
                return n - l;
            }
            return n;
        }
        return -1L;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int o = off;
        if (this.setreader()) {
            int m;
            for (int l = len; (m = this.reader.read(cbuf, o, l)) < l; l -= m) {
                this.reader.close();
                this.reader = null;
                if (this.setreader()) {
                    o += m;
                    continue;
                }
                return o + m;
            }
            return len;
        }
        return -1;
    }
}

