/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat.dist;

import net.morilib.awk.stat.DistributionUtils;
import net.morilib.awk.stat.dist.AbstractContinuousDistribution;
import net.morilib.awk.stat.special.Erf;

public class LogNormalDistribution
extends AbstractContinuousDistribution {
    private double mu;
    private double sigma2;

    public LogNormalDistribution(double mu, double sigma2) {
        if (sigma2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.mu = mu;
        this.sigma2 = sigma2;
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma2() {
        return this.sigma2;
    }

    public double expectedValue() {
        return Math.exp(this.mu + this.sigma2 / 2.0);
    }

    public double variance() {
        return Math.exp(2.0 * this.mu + this.sigma2) * (Math.exp(this.sigma2) - 1.0);
    }

    public double mode() {
        return Math.exp(this.mu - this.sigma2);
    }

    public double skewness() {
        return Math.sqrt(Math.exp(this.sigma2) - 1.0) * (Math.exp(this.sigma2) + 2.0);
    }

    public double kurtosis() {
        return Math.exp(4.0 * this.sigma2) + 2.0 * Math.exp(3.0 * this.sigma2) + 3.0 * Math.exp(2.0 * this.sigma2) - 6.0;
    }

    public double f(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double l = Math.log(x);
        double k = -((l - this.mu) * (l - this.mu) / 2.0 / this.sigma2);
        double a = 1.0 / Math.sqrt(Math.PI * 2 * this.sigma2) / x;
        return a * Math.exp(k);
    }

    public boolean isInSupport(double n) {
        return true;
    }

    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double l = Math.log(x);
        return DistributionUtils.trimCdf(0.5 * Erf.erfc(-(l - this.mu) / Math.sqrt(2.0 * this.sigma2)), 1.0E-13);
    }

    public double supportSupremum() {
        return Double.POSITIVE_INFINITY;
    }

    public double supportInfimum() {
        return 0.0;
    }

    public double median() {
        return Math.exp(this.mu);
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (r + (int)Double.doubleToLongBits(this.mu));
        r = 37 * (r + (int)Double.doubleToLongBits(this.sigma2));
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof LogNormalDistribution) {
            LogNormalDistribution n = (LogNormalDistribution)o;
            return this.mu == n.mu && this.sigma2 == n.sigma2;
        }
        return false;
    }
}

