/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.dc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public final class DcMath {
    private static final int BASE = 16;
    private static final int LOG2BASE = 4;
    private static final BigInteger LIMIT_NRT = BigInteger.valueOf(Integer.MAX_VALUE);

    private DcMath() {
    }

    public static final int minus1ToThe(int n) {
        return (n & 1) == 0 ? 1 : -1;
    }

    public static double decimalPart(double x) {
        double r = Math.IEEEremainder(x, 1.0);
        return r < 0.0 ? 1.0 + r : r;
    }

    public static boolean isInteger(double x) {
        return DcMath.decimalPart(x) == 0.0;
    }

    private static int toInt(byte b) {
        return b < 0 ? (b & 0x7F) + 128 : b;
    }

    private static int searchX(BigInteger v, BigInteger t) {
        BigInteger s;
        int x = 0;
        while ((s = v.shiftLeft(4).add(BigInteger.valueOf(x))).multiply(BigInteger.valueOf(x++)).compareTo(t) <= 0) {
        }
        return x - 2;
    }

    static BigInteger[] _sqrt(BigInteger q) {
        BigInteger s = BigInteger.ZERO;
        BigInteger t = BigInteger.ZERO;
        BigInteger r = BigInteger.ZERO;
        int i = 0;
        if (q.signum() == 0) {
            return new BigInteger[]{BigInteger.ZERO, BigInteger.ZERO};
        }
        if (q.signum() < 0) {
            throw new IllegalArgumentException();
        }
        byte[] a = q.toByteArray();
        while (i < a.length) {
            int x = 0;
            if (s.signum() == 0) {
                t = BigInteger.valueOf(DcMath.toInt(a[i]));
                while (x * x <= t.intValue()) {
                    ++x;
                }
                s = BigInteger.valueOf(--x);
            } else {
                t = t.shiftLeft(8);
                t = t.add(BigInteger.valueOf(DcMath.toInt(a[i])));
                x = DcMath.searchX(s, t);
                s = s.shiftLeft(4).add(BigInteger.valueOf(x));
            }
            t = t.subtract(s.multiply(BigInteger.valueOf(x)));
            s = s.add(BigInteger.valueOf(x));
            r = r.shiftLeft(4).add(BigInteger.valueOf(x));
            ++i;
        }
        return new BigInteger[]{r, t, s};
    }

    public static BigInteger sqrt(BigInteger q) {
        BigInteger[] r2 = DcMath._sqrt(q);
        return r2[1].signum() == 0 ? r2[0] : r2[0].negate();
    }

    public static BigDecimal sqrt(BigDecimal d) {
        int s = d.scale();
        BigDecimal f = d.setScale(s * 2 + 2);
        BigInteger a = f.unscaledValue();
        BigInteger[] q = DcMath._sqrt(a);
        BigDecimal x = new BigDecimal(q[0], s + 1);
        x = x.setScale(d.scale(), RoundingMode.HALF_UP);
        return x;
    }

    private static BigInteger[] split(BigInteger b, int n) {
        BigInteger x;
        byte[] c = b.toByteArray();
        int l = 0;
        while (c[l] == 0) {
            ++l;
        }
        byte[] d = new byte[(c.length - l) * 2];
        int k = l;
        while (k < c.length) {
            d[(k - l) * 2] = (byte)(DcMath.toInt(c[k]) >> 4);
            d[(k - l) * 2 + 1] = (byte)(DcMath.toInt(c[k]) & 0xF);
            ++k;
        }
        BigInteger[] r = new BigInteger[(d.length + n - 1) / n];
        int i = d.length % n;
        if (i > 0) {
            x = BigInteger.ZERO;
            k = 0;
            while (k < i) {
                x = x.shiftLeft(4).add(BigInteger.valueOf(DcMath.toInt(d[k])));
                ++k;
            }
            r[0] = x;
        }
        while (i < d.length) {
            x = BigInteger.ZERO;
            k = 0;
            while (k < n) {
                x = x.shiftLeft(4).add(BigInteger.valueOf(DcMath.toInt(d[i + k])));
                ++k;
            }
            r[(i + n - 1) / n] = x;
            i += n;
        }
        return r;
    }

    public static BigInteger nrtExact(BigInteger q, int n) {
        BigInteger r = BigInteger.ZERO;
        BigInteger t = BigInteger.ZERO;
        int i = 0;
        if (q.signum() == 0) {
            return BigInteger.ZERO;
        }
        if (q.signum() < 0) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        BigInteger[] a = DcMath.split(q, n);
        while (i < a.length) {
            int b = 0;
            t = t.shiftLeft(4 * n).add(a[i]);
            r = r.shiftLeft(4);
            while (b < 16) {
                BigInteger x = r.add(BigInteger.valueOf(b)).pow(n);
                if (x.compareTo(t) > 0) break;
                ++b;
            }
            r = r.add(BigInteger.valueOf(b - 1));
            ++i;
        }
        return t.subtract(q).signum() == 0 ? r : r.negate();
    }

    public static BigInteger nrtExact(BigInteger q, BigInteger n) {
        if (n.signum() < 0 || n.compareTo(LIMIT_NRT) > 0) {
            throw new IllegalArgumentException();
        }
        return DcMath.nrtExact(q, n.intValue());
    }
}

