/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.dc.number;

import java.math.BigInteger;
import net.morilib.dc.number.AbstractNumerical;
import net.morilib.dc.number.AlgebricInteger;
import net.morilib.dc.number.BigInt;
import net.morilib.dc.number.Rational;
import net.morilib.dc.number.SmallInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Integer2
extends AbstractNumerical<Integer2>
implements AlgebricInteger<Integer2> {
    private static final BigInteger _I_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger _I_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final Integer2 ZERO = Integer2.valueOf(0);
    public static final Integer2 ONE = Integer2.valueOf(1);

    Integer2() {
    }

    public static Integer2 valueOf(BigInteger val) {
        if (val.compareTo(_I_MAX) > 0 || val.compareTo(_I_MIN) < 0) {
            return new BigInt(val);
        }
        return new SmallInt(val.intValue());
    }

    public static Integer2 valueOf(int val) {
        return new SmallInt(val);
    }

    public static Integer2 valueOf(long val) {
        if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
            return new BigInt(BigInteger.valueOf(val));
        }
        return new SmallInt((int)val);
    }

    public byte toByte() {
        return (byte)this.toInt();
    }

    public short toShort() {
        return (short)this.toInt();
    }

    public abstract int toInt();

    public abstract long toLong();

    public abstract BigInteger toBigInteger();

    @Override
    public byte castByte() {
        return this.toByte();
    }

    @Override
    public short castShort() {
        return this.toShort();
    }

    @Override
    public int castInt() {
        return this.toInt();
    }

    @Override
    public long castLong() {
        return this.toLong();
    }

    @Override
    public Integer2 castInteger2() {
        return this;
    }

    @Override
    public int intFloor() {
        return this.toInt();
    }

    @Override
    public long longFloor() {
        return this.toLong();
    }

    @Override
    public int intCeil() {
        return this.toInt();
    }

    @Override
    public long longCeil() {
        return this.toLong();
    }

    @Override
    public final boolean isInteger() {
        return true;
    }

    @Override
    public Integer2 getInteger2Floor() {
        return this;
    }

    @Override
    public Integer2 getInteger2Ceil() {
        return this;
    }

    @Override
    public Rational getRational() {
        return Rational.valueOf(this, ONE);
    }
}

