/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.builtin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.sh.misc.IOs;
import net.morilib.unix.misc.OptionIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShCp
implements ShProcess {
    private static final int FORCE = 1;
    private static final int RETRIVE_LINK_ALL = 2;
    private static final int INTERACTIVE = 4;
    private static final int RETRIVE_LINK = 8;
    private static final int PRESERVE = 16;
    private static final int RECURSIVE = 32;

    private boolean _md(PrintStream err, ShFile g) {
        if (!g.isExist() && !g.mkdir()) {
            err.print("cp: cannot make directory `");
            err.print(g.toString());
            err.println("'.");
            return false;
        }
        return true;
    }

    private int _cp1(ShFileSystem fs, BufferedReader rd, PrintStream err, int f, ShFile g, List<String> l) throws IOException {
        for (String s : l) {
            ShFile h = fs.getFile(s);
            int x = this._cp2(fs, rd, err, f, h, g);
            if (x == 0) continue;
            return x;
        }
        return 0;
    }

    private int _cp2(ShFileSystem fs, BufferedReader rd, PrintStream err, int f, ShFile h, ShFile g) throws IOException {
        InputStream ins = null;
        PrintStream ous = null;
        if (!h.isExist()) {
            err.print("cp: ");
            err.print(h.toString());
            err.println(" not found.");
            return 2;
        }
        if (h.isFile() && !g.isExist()) {
            ins = h.getInputStream();
            ous = g.getPrintStream(false);
            IOs.copy(ins, ous);
            return 0;
        }
        if (h.isFile() && g.isFile()) {
            if ((f & 4) != 0) {
                err.print("cp: overwrite `");
                err.print(g.toString());
                err.print("'? ");
                String s = rd.readLine();
                if (!s.equalsIgnoreCase("y") && !s.equalsIgnoreCase("yes")) {
                    return 0;
                }
            }
            ins = h.getInputStream();
            ous = g.getPrintStream(false);
            IOs.copy(ins, ous);
            return 0;
        }
        if (h.isFile() && g.isDirectory()) {
            ShFile j = fs.getFile(g, h.getName());
            return this._cp2(fs, rd, err, f, h, j);
        }
        if (h.isDirectory() && (f & 0x20) == 0) {
            err.print("cp: ");
            err.print(h.toString());
            err.println(" must be a file.");
            return 2;
        }
        if (h.isDirectory() && !g.isExist()) {
            if (!this._md(err, g)) {
                return 2;
            }
            for (ShFile x : h.getFiles()) {
                ShFile j = fs.getFile(g, x.getName());
                this._cp2(fs, rd, err, f, x, j);
            }
            return 0;
        }
        if (h.isDirectory() && g.isDirectory()) {
            ShFile k = fs.getFile(g, h.getName());
            this._md(err, k);
            for (ShFile x : h.getFiles()) {
                ShFile j = fs.getFile(k, x.getName());
                this._cp2(fs, rd, err, f, x, j);
            }
            return 0;
        }
        err.print("cp: ");
        err.print(h.toString());
        err.println(" is an invalid object.");
        return 2;
    }

    @Override
    public int main(ShEnvironment env, ShFileSystem fs, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        String[] a = new String[args.length - 1];
        int f = 0;
        System.arraycopy(args, 1, a, 0, a.length);
        OptionIterator o = new OptionIterator("fHiLpRr", a);
        while (o.hasNext()) {
            switch (o.nextChar()) {
                case 'f': {
                    f |= 1;
                    break;
                }
                case 'H': {
                    f |= 2;
                    break;
                }
                case 'i': {
                    f |= 4;
                    break;
                }
                case 'L': {
                    f |= 8;
                    break;
                }
                case 'p': {
                    f |= 0x10;
                    break;
                }
                case 'R': 
                case 'r': {
                    f |= 0x20;
                    break;
                }
                default: {
                    err.print("cp: unrecognized option: ");
                    err.println((char)o.getErrorOption());
                    return 2;
                }
            }
        }
        Iterator<String> t = o.filenameIterator();
        while (t.hasNext()) {
            l.add(t.next());
        }
        int n = l.size();
        if (n < 2) {
            err.println("cp: too few arguments");
            return 2;
        }
        if (n == 2) {
            BufferedReader rd = new BufferedReader(new InputStreamReader(in, env.getCharset()));
            ShFile h = fs.getFile((String)l.get(0));
            ShFile g = fs.getFile((String)l.get(1));
            return this._cp2(fs, rd, err, f, h, g);
        }
        ShFile g = fs.getFile((String)l.get(n - 1));
        if (g.isDirectory()) {
            BufferedReader rd = new BufferedReader(new InputStreamReader(in, env.getCharset()));
            return this._cp1(fs, rd, err, f, g, l.subList(0, n - 1));
        }
        err.print("cp: ");
        err.print((String)l.get(n - 1));
        err.println(" must be a directory.");
        return 2;
    }
}

