<?php
//---------------------------------------------------------------------------
//Charactor set is UTF-8
//漢字コードはＵＴＦ－８
//---------------------------------------------------------------------------
function EncodeNames()
//$_POSTの内容をURLエンコードする
//日本語のファイル名やディレクトリ名に対応するため
{
	foreach($_POST as $key => $val) {
		if($key == 'nDirs') {
			foreach($_POST['nDirs'] as $key_files => $key_val) {	//nDirsはチェックボックスからの入力
				$_POST['nDirs'][$key_files] = urlencode($key_val);
			}
		} else if($key == 'nFiles') {
			foreach($_POST['nFiles'] as $key_files => $key_val) {	//nFilesはチェックボックスからの入力
				$_POST['nFiles'][$key_files] = urlencode($key_val);
			}
		} else {
			$vals = explode('/',$val);
			foreach($vals as $n => $v) {
				$vals[$n] = urlencode($v);
			}
			$_POST[$key] = implode('/',$vals);
		}
	}
}
//---------------------------------------------------------------------------
function DecodeName($pPath)
//パスの内容をURLデコードする
//引数		$pPath：変換するパス
//戻り値	変換した結果
{
	$vals = explode('/',$pPath);
	foreach($vals as $n => $v) {
		$vals[$n] = urldecode($v);
	}
	return(implode('/',$vals));
}
//---------------------------------------------------------------------------
class UFile {		//ファイル情報クラス（構造体）
	var	$mName;
	var	$mPath;		//プログラム上のパス
	var $mFullPath;	//実際のフルパス
	var	$mKind;
	var	$mSize;
	var	$mKBSize;	//一覧表用
	var	$mMTime;
	var	$mDate;		//一覧表用
}
//---------------------------------------------------------------------------
function ScanFiles($pPath,&$pDirs,&$pFiles)
//ディレクトリ内のファイル一覧を取得する
//引数		$pPath：一覧表を作るディレクトリのフルパス
//			&$pDirs,&$pFiles：ディレクトリとファイルの情報を入れて戻す
//戻り値	true：成功　false：エラーが起きた
{
	global	$gRootDir;

	$pDirs  = array();
	$pFiles = array();

	if($pPath == '/') $pPath = '';
	if (!($dh = @opendir($gRootDir . $pPath))) {	//セキュリティー確保のため密かにプログラム上のルートディレクトリを足す
		return(false);
	}
	while (false !== ($file = readdir($dh))) {
		if($file == '.' || $file == '..') continue;
		$tmp            = new UFile;
		$tmp->mName     = $file;
		$fullpath       = $gRootDir . $pPath . '/' . $file;
		$tmp->mPath     = $pPath;
		$tmp->mFullPath = $fullpath ;
		$tmp->mKind     = filetype($fullpath);
		$tmp->mSize     = filesize($fullpath);
		$tmp->mKBSize   = round(($tmp->mSize/1024)) . ' kB';
		$tmp->mMTime    = filemtime($fullpath);
		$tmp->mDate     = date("Y/m/d H:i", $tmp->mMTime);
		if($tmp->mKind == 'dir')  $pDirs[]  = $tmp;
		if($tmp->mKind == 'file') $pFiles[] = $tmp;
	}
	closedir($dh);

	return(true);
}
//---------------------------------------------------------------------------
function CmpByName($a,$b)
{
	if ($a->mName == $b->mName) {
		return 0;
	}
	return ($a->mName < $b->mName) ? -1 : 1;
}
//---------------------------------------------------------------------------
function CmpBySize($a,$b)
{
	if ($a->mSize == $b->mSize) {
		return 0;
	}
	return ($a->mSize < $b->mSize) ? -1 : 1;
}
//---------------------------------------------------------------------------
function CmpByDate($a,$b)
{
	if ($a->mMTime == $b->mMTime) {
		return 0;
	}
	return ($a->mMTime < $b->mMTime) ? -1 : 1;
}
//---------------------------------------------------------------------------
function CmpByNameR($a,$b)
{
	if ($a->mName == $b->mName) {
		return 0;
	}
	return ($a->mName < $b->mName) ? 1 : -1;
}
//---------------------------------------------------------------------------
function CmpBySizeR($a,$b)
{
	if ($a->mSize == $b->mSize) {
		return 0;
	}
	return ($a->mSize < $b->mSize) ? 1 : -1;
}
//---------------------------------------------------------------------------
function CmpByDateR($a,$b)
{
	if ($a->mMTime == $b->mMTime) {
		return 0;
	}
	return ($a->mMTime < $b->mMTime) ? 1 : -1;
}
//---------------------------------------------------------------------------
function MakeDirArray($pDir,&$pDirA,&$pDirB)
//一覧表で使うディレクトリ行列を作る
//引数		$pDir：ディレクトリ
//			&$pDirA：累積のパス配列を入れて返す
//			&$pDirB：個別のパス配列を入れて返す
{
	global	$gMsg;

	$pDirA = array();
	$pDirB = array();

	if($pDir == '/') {
		$pDirA[] = '/';
		$pDirB[] = $gMsg['RootDir'];
		return;
	}

	$d = explode('/',$pDir);
	$tpm = "";
	foreach($d as $key => $val) {
		if($key == 0) {
			$pDirA[] = '/';
			$pDirB[] = $gMsg['RootDir'];
		} else {
			$tmp     = $tmp . '/' . urldecode($val);
			$pDirA[] = $tmp;
			$pDirB[] = urldecode($val);
		}
	}
}
//---------------------------------------------------------------------------
function Ls($pDir)
//ディレクトリ内のファイル一覧表を出力する
//引数		$pDir：ディレクトリ
//$gRootDirからの相対ディレクトリ
//プログラム上のルートディレクトリは / となる
{
	global	$gMsg,$gImg,$gLang,$gOverWrite;

//ヘッダ出力
	if($gOverWrite) $msg_up_mode = $gMsg['UpNote04'];
	  else          $msg_up_mode = $gMsg['UpNote05'];
	print <<< kLs1
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html lang="{$gLang}">
<head>
<meta http-equiv="content-type" content="text/html;charset=utf-8">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta name="keywords" content="{$gMsg['keywords']}">
<meta name="description" content="{$gMsg['description']}">
<title>{$gMsg['title tag']}</title>
<link rel="stylesheet" type="text/css" href="lib/axlope.css">
<script type="text/javascript" src="lib/jquery.js"></script>
<script type="text/javascript" src="lib/jquery.treeview.js"></script>
<script type="text/javascript" src="lib/msg.{$gLang}.js"></script>
<script type="text/javascript" src="lib/axlope01.js"></script>
</head>
<body>

kLs1;
//ディレクトリ走査＆出力
	if($pDir == '') $pDir = '/';
	$ret = ScanFiles($pDir,$dirs,$files);
	if($ret == false) {
		echo "<div id=\"iHeader\">" . $gMsg['ScanFilesErr'] . DecodeName($pDir) . "</div>\n";
		echo "<div id=\"iFooter\">" . $gMsg['footer'] . "</div>\n</body>\n</html>\n";
		return;
	} else {
		echo '<div id="iHeader">'   . $gMsg['ScanFilesMsg'] . DecodeName($pDir) . "</div>\n";
	}

	switch($_COOKIE['cSort']) {
		case 'name_up':		usort($dirs,CmpByName);usort($files,CmpByName);break;
		case 'name_down':	usort($dirs,CmpByNameR);usort($files,CmpByNameR);break;
		case 'size_up':		usort($dirs,CmpBySize);usort($files,CmpBySize);break;
		case 'size_down':	usort($dirs,CmpBySizeR);usort($files,CmpBySizeR);break;
		case 'date_up':		usort($dirs,CmpByDate);usort($files,CmpByDate);break;
		case 'date_down':	usort($dirs,CmpByDateR);usort($files,CmpByDateR);break;
		default:			usort($dirs,CmpByDateR);usort($files,CmpByDateR);break;
	}
	MakeDirArray($pDir,$a,$b);	//ディレクトリ行列
	foreach($a as $key => $val) {
		$a[$key] =  "<span class=\"cPseudLink\" onclick=\"SendCmdForm('ls','{$a[$key]}')\"><img src=\"{$gImg['ls']}\" alt=\"{$b[$key]}\">{$b[$key]}</span>";
	}
	$dir_list = implode(" / \n",$a);
	$cur_dir =  DecodeName($pDir);

//表の上部
	print <<< kLs2
<form  id="iCmdForm" method="post" action="index.php">
<input id="iCmd"    type="hidden" name="nCmd"    value="">
<input id="iDir"    type="hidden" name="nDir"    value="$cur_dir">
<input id="iSrcDir" type="hidden" name="nSrcDir" value="$cur_dir">
<input id="iDstDir" type="hidden" name="nDstDir" value="">
<input id="iFile"   type="hidden" name="nFile"   value="">
<input id="iParam"  type="hidden" name="nParam"  value="">

<div align="center">
<table id="iDirFileTable">

<tr>
<td colspan="4" class="cMenu1">
<span class="cPseudLink" onclick="SendCmdForm('cd_dlog','')"><img src="{$gImg['tree']}" alt="{$gMsg['tree']}">{$gMsg['tree']}</span>  | 
<span class="cPseudLink" onclick="SendCmdForm('mkdir_dlog','')"><img src="{$gImg['mkdir']}" alt="{$gMsg['mkdir']}">{$gMsg['mkdir']}</span> |
<span class="cPseudLink" onclick="SendCmdForm('about','')"><img src="{$gImg['about']}" alt="{$gMsg['about']}">{$gMsg['about']}</span> |
$dir_list
</td>
</tr>

<tr class="cMenu2">
<th id="iCheck"><input id='iAllCheck' type="checkbox" name="nAllCheck" onclick="ToggleCheckBox()" value="none"></th>
<th id="iColName">{$gMsg['th_name']}<span class="cPseudLink" onclick="SendCmdForm('sort','name_up')"><img src="{$gImg['arrow_up']}" alt=""></span> <span class="cPseudLink" onclick="SendCmdForm('sort','name_down')"><img src="{$gImg['arrow_down']}" alt=""></span></th>
<th id="iColSize">{$gMsg['th_size']}<span class="cPseudLink" onclick="SendCmdForm('sort','size_up')"><img src="{$gImg['arrow_up']}" alt=""></span> <span class="cPseudLink" onclick="SendCmdForm('sort','size_down')"><img src="{$gImg['arrow_down']}" alt=""></span></th>
<th id="iColMod"> {$gMsg['th_date']}<span class="cPseudLink" onclick="SendCmdForm('sort','date_up')"><img src="{$gImg['arrow_up']}" alt=""></span> <span class="cPseudLink" onclick="SendCmdForm('sort','date_down')"><img src="{$gImg['arrow_down']}" alt=""></span></th>
</tr>

kLs2;

	$c = 1;
//ディレクトリ
	foreach($dirs as $key => $val) {
		if($c % 2 == 0) printf("\n<tr class=\"cEvenColor\">\n");
		  else          printf("\n<tr class=\"cOddColor\">\n");
		$DecodedFileName = urldecode($val->mName);
		printf("<td><input type=\"checkbox\" name=\"nDirs[]\" value=\"$DecodedFileName\"></td>\n");
		printf("<td><img src=\"{$gImg['folder']}\" alt=\"$DecodedFileName\"><span class=\"cPseudLink\" onclick=\"SendCmdForm('ls_d','$DecodedFileName')\">$DecodedFileName</span></td>\n");
		printf("<td style=\"text-align:center;\">---</td>\n<td style=\"text-align:right;\">$val->mDate</td>\n</tr>\n");
		$c++;
	}

//ファイル
	foreach($files as $key => $val) {
		if($c % 2 == 0) printf("\n<tr class=\"cEvenColor\">\n");
		  else          printf("\n<tr class=\"cOddColor\">\n");
		$DecodedFileName = urldecode($val->mName);
		printf("<td><input type=\"checkbox\" name=\"nFiles[]\" value=\"$DecodedFileName\"></td>\n");
		printf("<td><img src=\"{$gImg['file']}\" alt=\"$DecodedFileName\"><span class=\"cPseudLink\" onclick=\"SendCmdForm('download','$DecodedFileName')\">$DecodedFileName</span></td>\n");
		printf("<td style=\"text-align:right;\">$val->mKBSize</td>\n<td style=\"text-align:right;\">$val->mDate</td>\n</tr>\n");
		$c++;
	}

//下部
	$UploadMaxFilesize  = get_cfg_var("upload_max_filesize");
	$MAX_FILE_SIZE      = $UploadMaxFilesize * 1000000;
	print <<< kLs4
<tr>
<td class="cMenu3" colspan="4">
<img src="{$gImg['cp']}" alt="{$gMsg['cp']}"><span class="cPseudLink" onclick="SendCmdForm('cp_dlog','')">{$gMsg['cp']}</span> | 
<img src="{$gImg['mv']}" alt="{$gMsg['mv']}"><span class="cPseudLink" onclick="SendCmdForm('mv_dlog','')">{$gMsg['mv']}</span> | 
<img src="{$gImg['del']}" alt="{$gMsg['del']}"><span class="cPseudLink" onclick="SendCmdForm('del','')">{$gMsg['del']}</span> | 
<img src="{$gImg['ren']}" alt="{$gMsg['ren']}"><span class="cPseudLink" onclick="SendCmdForm('ren_dlog','')">{$gMsg['ren']}</span> |
<img src="{$gImg['upload']}" alt="{$gMsg['upload']}"><span class="cPseudLink" onclick="SendCmdForm('upload_dlog','')">{$gMsg['upload']}</span>
</td>
</tr>

</table>
</div>
</form>

<!-- 案内用汎用エレメント -->
<div id="iInfo">
</div>

<!-- ディレクトリツリーダイアローグ -->
<div id="iDirList">
</div>

<!-- ファイルアップロードダイアローグ -->
<!-- Ajaxでファイルをアップロードすることはできない -->
<div id="iUpLoadDlog">
<h1 class="cDlogHeader">{$gMsg['UpLoadMsg']}</h1>
<form id="iUPLoad" name="iUPLoad" method="post" action="index.php" enctype="multipart/form-data">
<input type="hidden" name="nCmd" value="upload">
<input type="hidden" name="nDir" value="{$cur_dir}">
<input type="hidden" name="MAX_FILE_SIZE" value="{$MAX_FILE_SIZE}">
<table>
<tr class="cMenu2"><th>No.</th><th>{$gMsg['File']}</th></tr>
<tr class="cOddColor" ><td>1</td><td><input type="file" id="iUP0" name="nUP[]" size="60"></td></tr>
<tr class="cEvenColor"><td>2</td><td><input type="file" id="iUP1" name="nUP[]" size="60"></td></tr>
<tr class="cOddColor" ><td>3</td><td><input type="file" id="iUP2" name="nUP[]" size="60"></td></tr>
<tr class="cEvenColor"><td>4</td><td><input type="file" id="iUP3" name="nUP[]" size="60"></td></tr>
<tr class="cOddColor" ><td>5</td><td><input type="file" id="iUP4" name="nUP[]" size="60"></td></tr>
</table>
{$gMsg['UpNote01']}
{$gMsg['UpNote02']} $UploadMaxFilesize {$gMsg['UpNote03']}
{$msg_up_mode}
<div class="cDlogFooter">
<input type="button" value="{$gMsg['CloseButton']}" onclick="$('#iUpLoadDlog').hide()">
<input type="submit" value="{$gMsg['DecisionButton']}">
</div>
</form>
</div>

<!-- ディレクトリ作成ダイアローグ -->
<div id="iMkDirDlog">
<h1 class="cDlogHeader">{$gMsg['PromptMkDir']}</h1>
<form  id="iMkDir" method="post" action="index.php">
<input id="iMkDirName" name="nMkDirName" type="text" size="50" maxlength="40"><br>
{$gMsg['DirCaution']}
<div class="cDlogFooter">
<input type="button" value="{$gMsg['CloseButton']}" onclick="$('#iMkDirDlog').hide()">
<input type="button" value="{$gMsg['DecisionButton']}"   onclick="SendCmdForm('mkdir','')">
</div>
</form>
</div>

<!-- 名前変更ダイアローグ -->
<div id="iRenDlog">
<h1 class="cDlogHeader">{$gMsg['PromptRen']}</h1>
<form  id="iRen" method="post" action="index.php">
<input id="iRenName" name="nRenName" type="text" size="50" maxlength="50">
<div class="cDlogFooter">
<input type="button" value="{$gMsg['CloseButton']}" onclick="$('#iRenDlog').hide()">
<input type="button" value="{$gMsg['DecisionButton']}"   onclick="SendCmdForm('ren','')">
</div>
</form>
</div>

<div id="iFooter">{$gMsg['footer']}</div>

</body>
</html>

kLs4;
}
//---------------------------------------------------------------------------
?>
