//---------------------------------------------------------------------------
//Charactor set is UTF-8
//漢字コードはＵＴＦ－８
//---------------------------------------------------------------------------
$(document).ready(function () {
//初期設定
	$('#iDirList').hide();
	$('#iUpLoadDlog').hide();
	$('#iMkDirDlog').hide();
	$('#iRenDlog').hide();
	$('#iInfo').hide();
	$.ajaxSetup({async : false});	//同期通信にする
});
//---------------------------------------------------------------------------
function SendCmdForm(pCmd,pParam)
//iCmdFormを送る
//引数	pCmd：コマンド
//		pParam：パラメータ
{
	$('#iCmd').val(pCmd);
	$('#iParam').val(pParam);

	switch(pCmd) {
		case 'ls':			$('#iCmdForm').submit();break;	//表の上のディレクトリをクリックした
		case 'ls_d':		$('#iCmdForm').submit();break;	//一覧表内のディレクトリをクリックした
		case 'sort':		$('#iCmdForm').submit();break;	//ソートする
		case 'download':	$('#iFile').val(pParam);		//ファイルをダウンロードする
							$('#iCmdForm').submit();break;
		case 'mkdir_dlog':	$('#iMkDirDlog').show();break;	//ディレクトリを作成する入力ダイアローグを出す
		case 'mkdir':		if(CheckMkDirName()) {			//文字列をチェックしてディレクトリ作成
								$('#iMkDirDlog').hide();
								$('#iFile').val($('#iMkDirName').val());
								$('#iCmdForm').submit();
							}
							break;
		case 'del':			if(CountCkeckedItem()) {		//チェックボックスを検査、戻りがtrueならば確認ダイアローグを出して実行
								if(confirm(gMsg['DelMsg'])) {
									$('#iCmdForm').submit();
								}
							}
							break
		case 'cp_dlog':		if(CountCkeckedItem()) {		//チェックボックスを検査、戻りがtrueならばダイアローグに任せる
								$('#iDirList').load('index.php',{'nCmd' : 'cp_dlog'});
								$('#iDirList').show();
								$('ul','#iDirList').Treeview();
							}
							break;
		case 'mv_dlog':		if(CountCkeckedItem()) {		//チェックボックスを検査、戻りがtrueならばダイアローグに任せる
								$('#iDirList').load('index.php',{'nCmd' : 'mv_dlog'});
								$('#iDirList').show();
								$('ul','#iDirList').Treeview();
							}
							break;
		case 'ren_dlog':	if(CheckRenItem()) {			//チェックボックスを検査、戻りがtrueならばダイアローグに任せる
								$('#iRenDlog').show();
							}
							break;
		case 'ren':			if(CheckRenName()) {			//文字列をチェックして名前変更
								$('#iRenDlog').hide();
								dirs  = $("input[@name='nDirs[]'][@checked]").size();	//ファイル、ディレクトリのどちらを変更しようとしているか
								if(dirs == 1) {
									$('#iFile').val($('input[@name="nDirs[]"][@checked]').val());
								} else {
									$('#iFile').val($('input[@name="nFiles[]"][@checked]').val());
								}
								$('#iParam').val($('#iRenName').val());
								$('#iCmdForm').submit();
							}
							break;
		case 'cd_dlog':		$('#iDirList').load('index.php',{'nCmd' : 'cd_dlog'});	//ディレクトリ変更ダイアローグを出す
							$('#iDirList').show();
							$('ul','#iDirList').Treeview();
							break;
		case 'upload_dlog':	ClearUpFiles();				//アップロードダイアローグに任せる
							$('#iUpLoadDlog').show();
							break;
		case 'about':		$('#iInfo').load('index.php',{'nCmd' : 'about'});	//このソフトについて
							$('#iInfo').show();
							break;
	}
}
//---------------------------------------------------------------------------
function SendCmdForm2(pCmd)
//iCmdFormを送る(ディレクトリ変更、複写、移動)
//引数	pCmd：コマンド
{
	if(null == $("input[@type=radio][@checked]").val()) {
		alert(gMsg['SelectRadio']);
		return false;
	}

	if(pCmd == 'cp' || pCmd == 'mv') {
		SrcDir = $('#iDir').val();
		DstDir = $("input[@type=radio][@checked]").val();
		if(SrcDir == DstDir) {
			alert(gMsg['SameDir']);		//同じディレクトリに複写、移動することはできない
			return false;
		}
	}

	$('#iDirList').hide();
	$('#iCmd').val(pCmd);
	$('#iDstDir').val($("input[@type=radio][@checked]").val());
	$('#iParam').val($("input[@type=radio][@checked]").val());
	$('#iCmdForm').submit();

	return true;
}
//---------------------------------------------------------------------------
function IsValidName(pStr)
//名前が妥当かどうか検査する
//引数		pStr：検査する文字列
//戻り値	true:妥当　false:妥当でない
{
	if(pStr == '') {
		alert(gMsg['NoInput']);
		return false;
	}

	if(pStr.match(/[\\/:*?"<>|]/)) {
		alert(gMsg['InvalidChar']);
		return false;
	}
	return true;
}
//---------------------------------------------------------------------------
function CheckMkDirName()
//ディレクトリ作成入力の文字列検査
{
	name = $('#iMkDirName').val();

	flag = IsValidName(name);
	if(flag == false) return false;

	nameA = name.toLowerCase();

	flag = true;
	$("input[@name='nDirs[]']").each(function () {
		nameB = this.value;
		nameB = nameB.toLowerCase();
		if(nameA == nameB) flag = false;
	});

	if(flag == false) alert(gMsg['MkDirErr']);
	return flag;
}
//---------------------------------------------------------------------------
function ToggleCheckBox()
//チェックボックスをすべて反転させる
{
	if($('#iAllCheck').attr('checked')) {
		$("input[@name='nDirs[]']").attr('checked',true);
		$("input[@name='nFiles[]']").attr('checked',true);
	} else {
		$("input[@name='nDirs[]']").attr('checked',false);
		$("input[@name='nFiles[]']").attr('checked',false);
	}
}
//---------------------------------------------------------------------------
function CheckRenItem()
//名前を変更するアイテムをチェックする
{
	dirs  = $("input[@name='nDirs[]'][@checked]").size();
	files = $("input[@name='nFiles[]'][@checked]").size();
	items = dirs + files;

	if(items == 0) {
		alert(gMsg['RenErr0']);
		return false;
	}
	if(items != 1) {
		alert(gMsg['RenErr1']);
		return false;
	}

	//名前変更ダイアローグへ現在の名前を入れる
	if(dirs == 1) {
		$('#iRenName').val($("input[@name='nDirs[]'][@checked]").val());
	} else {
		$('#iRenName').val($("input[@name='nFiles[]'][@checked]").val());
	}

	return true;
}
//---------------------------------------------------------------------------
function CheckRenName()
//名前を変更するときに、名前が重なっていないかどうかチェックする
{
	name = $('#iRenName').val();
	flag = IsValidName(name);
	if(flag == false) return false;

	nameA = name.toLowerCase();

	flag = true;
	$("input[@name='nDirs[]']").each(function () {
		nameB = this.value;
		nameB = nameB.toLowerCase();
		if(nameA == nameB) flag = false;
	});
	$("input[@name='nFiles[]']").each(function () {
		nameB = this.value;
		nameB = nameB.toLowerCase();
		if(nameA == nameB) flag = false;
	});

	if(flag == false) alert(gMsg['RenErr2']);
	return flag;
}
//---------------------------------------------------------------------------
function CountCkeckedItem()
//複写、移動、削除でチェックされた物があるかどうか検査する
{
	dirs  = $("input[@name='nDirs[]'][@checked]").size();
	files = $("input[@name='nFiles[]'][@checked]").size();
	items = dirs + files;

	if(items == 0) {
		alert(gMsg['ChkErr0']);
		return false;
	}
	return true;
}
//---------------------------------------------------------------------------
function ClearUpFiles()
//アップロードファイルの欄をクリアする
{
	document.iUPLoad.reset();
}
//---------------------------------------------------------------------------
