<?php
//---------------------------------------------------------------------------
//Charactor set is UTF-8
//漢字コードはＵＴＦ－８
//---------------------------------------------------------------------------
function RemoveDirectory($pDir)
//ディレクトリを、その下にあるファイルごと消す
//引数	$pDir：ディレクトリ
{
	if($handle = opendir("$pDir")) {
		while(false !== ($item = readdir($handle))) {
			if ($item != "." && $item != "..") {
				if (is_dir("$pDir/$item")) {
					RemoveDirectory("$pDir/$item");
				} else {
					unlink("$pDir/$item");
				}
			}
		}
		closedir($handle);
		rmdir($pDir);
	}
}
//---------------------------------------------------------------------------
function DelFiles()
//ファイルやフォルダを削除する
//引数	$gRootDir:ルートディレクトリ
//		$_POST['nDir']:プログラムから見たディレクトリ
//		$_POST['nFiles[]']:削除するディレクトリやファイル
{
	global	$gRootDir;

	if(isset($_POST["nDirs"])) {
		foreach($_POST["nDirs"] as $key => $val) {
			RemoveDirectory($gRootDir . $_POST['nDir'] . '/' . $val);		//ディレクトリ削除
		}
	}
	if(isset($_POST["nFiles"])) {
		foreach($_POST["nFiles"] as $key => $val) {
			unlink($gRootDir . $_POST['nDir'] . '/' . $val);				//ファイル削除
		}
	}
}
//---------------------------------------------------------------------------
?>
