<?php
//---------------------------------------------------------------------------
//Charactor set is UTF-8
//漢字コードはＵＴＦ－８
//---------------------------------------------------------------------------
$UpLoadFiles = array();
$Result      = array();
//---------------------------------------------------------------------------
function UniqName($pPath,$pName)
//ファイル名に (n) を付ける
//引数		$pPath：パス（最後の / 付き)
//			$pNameファイル名
//戻り値	ユニークなファイル名を返す
{
	$ext = pathinfo($pName,PATHINFO_EXTENSION);
	if($ext != '') {
		$name = substr($pName,0,strlen($pName) - strlen($ext) - 1);
	} else {
		$name = $pName;
	}
	for($c=1;;$c++) {
		if($c < 10) {
			$path = $pPath . $name . urlencode('(0' . $c . ').') . $ext;
		} else {
			$path = $pPath . $name . urlencode('('  . $c . ').') . $ext;
		}
		if(! file_exists($path)) break;
	}
	return($path);
}
//---------------------------------------------------------------------------
function UpLoadFiles()
//アップロード処理
//Ajaxでファイルをアップロードすることはできない
{
	global	$gRootDir,$UpLoadFiles,$Result,$gMsg,$gOverWrite;

	$UpLoadFiles = array();
	$Result      = array();

	foreach($_FILES['nUP']['error'] as $i => $val) {
		switch($val) {
			case UPLOAD_ERR_OK:			//エラー無し
					$name = urlencode($_FILES['nUP']['name'][$i]);	//アップロードされたファイル名を変える
					$tmp  = $gRootDir . $_POST['nDir'] . '/' . $name;
					if(file_exists($tmp) && !$gOverWrite) {			//すでにファイルが存在する場合
						$tmp = UniqName($gRootDir . $_POST['nDir'] . '/',$name);
					}
					move_uploaded_file($_FILES['nUP']['tmp_name'][$i],$tmp);
					$UpLoadFiles[] = urldecode(basename($tmp));
					$Result[]      = $gMsg['UPLOAD_ERR_OK'];
					break;
			case UPLOAD_ERR_INI_SIZE:
					$UpLoadFiles[] = $_FILES['nUP']['name'][$i];
					$Result[]      = $gMsg['UPLOAD_ERR_INI_SIZE'];
					break;
			case UPLOAD_ERR_FORM_SIZE:
					$UpLoadFiles[] = $_FILES['nUP']['name'][$i];
					$Result[]      = $gMsg['UPLOAD_ERR_FORM_SIZE'];
			case UPLOAD_ERR_PARTIAL:
					$UpLoadFiles[] = $_FILES['nUP']['name'][$i];
					$Result[]      = $gMsg['UPLOAD_ERR_PARTIAL'];
					break;
			case UPLOAD_ERR_NO_FILE:	//ファイルはアップロードされませんでした。 
					break;
			case UPLOAD_ERR_NO_TMP_DIR:
					$UpLoadFiles[] = $_FILES['nUP']['name'][$i];
					$Result[]      = $gMsg['UPLOAD_ERR_NO_TMP_DIR'];
					break;
			case UPLOAD_ERR_CANT_WRITE:
					$UpLoadFiles[] = $_FILES['nUP']['name'][$i];
					$Result[]      = $gMsg['UPLOAD_ERR_CANT_WRITE'];
					break;
			case UPLOAD_ERR_EXTENSION:
					$UpLoadFiles[] = $_FILES['nUP']['name'][$i];
					$Result[]      = $gMsg['UPLOAD_ERR_EXTENSION'];
					break;
			default:
					$UpLoadFiles[] = $_FILES['nUP']['name'][$i];
					$Result[]      = $gMsg['UPLOAD_ERR_DEFAULT'];
		}
	}
}
//---------------------------------------------------------------------------
function UpLoadResult()
//アップロードの結果表示
{
	global	$gRootDir,$UpLoadFiles,$Result,$gMsg,$gImg,$gLang;

	$cur_dir = DecodeName($_POST['nDir']);
	print <<< kUpLoadResult1
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html lang="{$gLang}">
<head>
<meta http-equiv="content-type" content="text/html;charset=utf-8">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta name="keywords" content="{$gMsg['keywords']}">
<meta name="description" content="{$gMsg['description']}">
<title>{$gMsg['title tag']}</title>
<link rel="stylesheet" type="text/css" href="lib/axlope.css">
<script type="text/javascript" src="lib/jquery.js"></script>
<script type="text/javascript" src="lib/jquery.treeview.js"></script>
<script type="text/javascript" src="lib/msg.{$gLang}.js"></script>
<script type="text/javascript" src="lib/axlope01.js"></script>
</head>
<body>
<div id="iHeader">{$gMsg['UploadResult']}</div>

<form  id="iCmdForm" method="post" action="index.php">
<input id="iCmd"    type="hidden" name="nCmd"    value="ls">
<input id="iDir"    type="hidden" name="nDir"    value="$cur_dir">
<input id="iParam"  type="hidden" name="nParam"  value="$cur_dir">

<div align="center">
<table>
<tr class="cMenu2"><td>No.</td><td>{$gMsg['UploadFileName']}</td><td>{$gMsg['UploadResultMsg']}</td></tr>

kUpLoadResult1;
	$c = 1;
	foreach($UpLoadFiles as $key => $val) {
		if($c % 2 == 0) printf("\n<tr class=\"cEvenColor\">");
		  else          printf("\n<tr class=\"cOddColor\">");
		echo "<td>$c</td><td>{$cur_dir}/$val</td><td>{$Result[$key]}</td></tr>\n";
		$c++;
	}

	print <<< kUpLoadResult2
<tr class="cMenu3"><td colspan="3"><input type="submit" value="{$gMsg['ListDirMsg']}"></td></tr>
</table>
</div>
</form>

<div id="iFooter">{$gMsg['footer']}</div>
</body>
</html>

kUpLoadResult2;
}
//---------------------------------------------------------------------------
?>
