<?php
//---------------------------------------------------------------------------
//Charactor set is UTF-8
//漢字コードはＵＴＦ－８
//---------------------------------------------------------------------------
$gDirs  = array();
$gFiles = array();
//---------------------------------------------------------------------------
function ScanDirAndFiles($pPath,$pRelDir='')
//ディレクトリとファイルを再帰検索する
//引数		$pPath：走査するディレクトリ $gRootDir . $pPath で本当のディレクトリ
//			$pRelDir：起点となったディレクトリからの相対ディレクトリ
//戻り値	true：成功　false：エラーが起きた
{
	global	$gRootDir,$gDirs,$gFiles;

	if($pPath   == '/') $pPath   = '';
	if($pRelDir == '/') $pRelDir = '';
	if (!($dh = opendir($gRootDir . $pPath))) {
		return(false);
	}

	while (false !== ($file = readdir($dh))) {
		if($file == '.' || $file == '..') continue;
		$ProgramPath =             $pPath . '/' . $file;	//プログラムのルートから見たパス
		$FullPath    = $gRootDir . $pPath . '/' . $file;	//フルパス
		$aPath       =          $pRelDir  . '/' . $file;	//ScanDirAndFilesの起点から見たパス
		if(filetype($FullPath) == 'dir')  {
			$gDirs[] = $aPath;
			ScanDirAndFiles($ProgramPath,$pRelDir . '/' . $file);
		}
		if(filetype($FullPath) == 'file')  {
			$gFiles[] = $aPath;
		}
	}
	closedir($dh);

	return(true);
}
//---------------------------------------------------------------------------
function CopyDirAndFiles($pSrc,$pDst)
//ディレクトリとファイルをコピーする
//引数		$pSrc：複写元  $gRootDir . $pSrc で本当のディレクトリ
//			$pDst：複写先
//			$gDirs,$gFiles：コピーするディレクトリとファイル
{
	global	$gRootDir,$gDirs,$gFiles;

	if($pSrc == '/') $pSrc = '';
	if($pDst == '/') $pDst = '';
	foreach($gDirs as $directory) {
		mkdir($gRootDir . $pDst . $directory);
	}
	foreach($gFiles as $file) {
		copy($gRootDir . $pSrc . $file , $gRootDir . $pDst . $file);
	}
}
//---------------------------------------------------------------------------
function CopyFiles()
//複写処理
//引数	$gRootDir:ルートディレクトリ
//		$_POST['nDir']:プログラムから見たディレクトリ
//		$_POST['nSrcDir']:複写元 = $_POST['nDir']
//		$_POST['nDstDir']:複写先
{
	global	$gRootDir;

	if(isset($_POST['nDirs'])) {
		foreach($_POST['nDirs'] as $d) {
			$gDirs  = array();
			$gFiles = array();
			ScanDirAndFiles($_POST['nSrcDir']  . '/' . $d);						//コピーするものを列挙する
			mkdir($gRootDir. $_POST['nDstDir'] . '/' . $d);
			CopyDirAndFiles($_POST['nSrcDir']  . '/' . $d,$_POST['nDstDir'] . '/' . $d);		//ディレクトリを作ってファイルをコピー
		}
	}

	if(isset($_POST['nFiles'])) {
		foreach($_POST['nFiles'] as $f) {
			copy($gRootDir. $_POST['nSrcDir']  . '/' . $f , $gRootDir. $_POST['nDstDir'] . '/' . $f);
		}
	}
}
//---------------------------------------------------------------------------
?>
