/*
    SDL_cfg:  An configuration file parser based on the SDL library
    Copyright (C) 2001-2007 kr2

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    kr2
    ee12054g@hotmail.co.jp
*/
/* $Id: SDL_cfg.h 1599 2007-01-13 13:23:21Z icculus $ */
#ifndef __SDL_CFG_H__
#define __SDL_CFG_H__

#include <SDL.h>

#include "begin_code.h"

/* Set up for C function definitions, even when using C++ */
#ifdef __cplusplus
extern "C" {
#endif

/* Printable format: "%d.%d.%d", MAJOR, MINOR, PATCHLEVEL
*/
#define SDL_CFG_MAJOR_VERSION	0
#define SDL_CFG_MINOR_VERSION	0
#define SDL_CFG_PATCHLEVEL	1

/* This macro can be used to fill a version structure with the compile-time
 * version of the SDL_cfg library.
 */
#define SDL_CFG_VERSION(X)						\
{									\
	(X)->major = SDL_CFG_MAJOR_VERSION;				\
	(X)->minor = SDL_CFG_MINOR_VERSION;				\
	(X)->patch = SDL_CFG_PATCHLEVEL;				\
}

/* Backwards compatibility */
#define CFG_MAJOR_VERSION	SDL_CFG_MAJOR_VERSION
#define CFG_MINOR_VERSION	SDL_CFG_MINOR_VERSION
#define CFG_PATCHLEVEL		SDL_CFG_PATCHLEVEL
#define CFG_VERSION(X)		SDL_CFG_VERSION(X)

/* This function gets the version of the dynamically linked SDL_cfg library.
   it should NOT be used to fill a version structure, instead you should
   use the SDL_CFG_VERSION() macro.
 */
extern DECLSPEC const SDL_version * SDLCALL CFG_Linked_Version(void);

/* The internal format for a configuration file */
typedef struct _CFG_Object CFG_Object ;

/*
	sꍇNULLԂ
	KCFG_Freeŉ邱

	ǂݍݐpŊJꍇCFG_Loadł͂Ȃ
	CFG_LoadRWŁASDL_RWopsǂݍݐpŊJnƁB
*/
extern DECLSPEC CFG_Object* SDLCALL CFG_LoadRW(SDL_RWops* src);
#define CFG_Load(file) CFG_LoadRW(SDL_RWFromFile(file, "r+b"))

extern DECLSPEC void SDLCALL CFG_Free(CFG_Object* obj);

/*
	vfւ̏/擾
*/
extern DECLSPEC int SDLCALL CFG_SetString ( CFG_Object* obj, const char* proppath, const char* propval) ;
extern DECLSPEC int SDLCALL CFG_SetInteger (CFG_Object* obj, const char* proppath, int propval );
extern DECLSPEC int SDLCALL CFG_SetDouble (CFG_Object* obj, const char* proppath, double propval );

extern DECLSPEC const char* SDLCALL CFG_GetString ( CFG_Object* obj, const char* proppath ) ;
extern DECLSPEC int SDLCALL CFG_GetInteger (CFG_Object* obj, const char* proppath, int* prop  );
extern DECLSPEC int SDLCALL CFG_GetDouble (CFG_Object* obj, const char* proppath, double* prop );

/* Ends C function definitions when using C++ */
#ifdef __cplusplus
}
#endif
#include "close_code.h"


#endif /* __SDL_CFG_H__ */
