/*
    SDL_cfg:  An configuration file parser based on the SDL library
    Copyright (C) 2001-2007 kr2

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    kr2
    ee12054g@hotmail.co.jp
*/
#include "SDL_cfg.h"
#include "XMLDocument.hpp"

struct _CFG_Object {
	_CFG_Object ( SDL_RWops* rwops )
	{
		m_pSrcRW = rwops ;
	}

	~_CFG_Object ()
	{
		if ( m_pXmlDoc != NULL ) delete m_pXmlDoc ;
	}

	/*!
		ݒt@C[h
		InitĂяoƁAȑOJĂݒt@C͕B
		ݒt@C݂Ȃꍇ́AB
		s-1,0ԂB
	*/
	int Init ()
	{
		if ( m_pSrcRW == NULL ) return -1 ;
		m_pXmlDoc = new XMLDocument ( m_pSrcRW ) ;
		if ( m_pXmlDoc == NULL ) {
			return -1 ;
		}
		// [gGg̖Oݒ
		XMLElement* relem = m_pXmlDoc->GetRootElem() ;
		if ( relem == NULL ) return -1 ;
		relem->SetName ( "SDL_cfg" ) ;
		m_pXmlDoc->Save () ;
		return 0 ;
	}

	/*
		ݒ̓ǂݏoƏo
		0,s-1
	*/
	int Set ( const char* proppath, const char* propval ) ;
	int Set ( const char* proppath, int propval ) ;
	int Set ( const char* proppath, double propval ) ;

	const char* Get (const char* proppath ) ;
	int Get ( int& prop, const char* proppath ) ;
	int Get ( double& prop, const char* proppath ) ;

	int GetDirCount ( const char* path ) ;
	const char* GetNextDirName ( char* dst, const char* path ) ;

	XMLDocument *m_pXmlDoc ;
	SDL_RWops*	m_pSrcRW ;
} ;

int _CFG_Object::GetDirCount ( const char* path )
{
	int cnt = 0, i ;
	for ( i=0; path[i]!=(char)NULL; i++ ) {
		if ( path[i] == '/' ) cnt++ ;
	}
	// [g/oȂꍇ̏u
	if ( path[0] != '/' ) cnt++ ;
	// [f~^ŏIĂꍇ̏u
	if ( path[i-1] == '/' ) cnt-- ;
	return cnt ;
}

/*
	fBNg擾B
	dstɃfBNgAԗlƂĎ̃fBNgւ
	|C^ԂB 
*/
const char* _CFG_Object::GetNextDirName ( char* dst, const char* path )
{
	int i ;
	const char* src ;
	if ( path[0] == '/' ) src = &path[1] ;
	else src = path ;
	for ( i=0; src[i]!='/'&&src[i]!=(char)NULL; i++ ) dst[i]=src[i] ;
	dst[i] = (char)NULL ;
	return &src[i] ;
}

// ݒ̓ǂݏoƏo //
int _CFG_Object::Set ( const char* proppath, const char* propval )
{
	if ( proppath != NULL && propval != NULL ) {
		// Ƃ肠A[g擾
		XMLElement* elem = m_pXmlDoc->GetRootElem () ;
		int dcount = GetDirCount (proppath) ;
		int i ;
		const char* nextpath = proppath;
		char buf[500] ;
		// ċAIɁAړĨGg
		for ( i=0; i<dcount-1; i++ ) {
			nextpath = GetNextDirName ( buf, nextpath ) ;
			elem = elem->SetElem (buf) ;
		}
		// Ō̃pXAvpeBƂĔF
		GetNextDirName ( buf, nextpath ) ;
		elem->SetPropStr ( buf, propval ) ;
		m_pXmlDoc->Save () ;
		return 0 ;
	}
	return -1 ;
}

int _CFG_Object::Set ( const char* proppath, int propval )
{
	char buf[256] ;
	sprintf( buf, "%d", propval ) ;
	return Set ( proppath, buf ) ;
}

int _CFG_Object::Set ( const char* proppath, double propval )
{
	char buf[256] ;
	sprintf ( buf, "%le", propval ) ;
	return Set ( proppath, buf ) ;
}

const char* _CFG_Object::Get ( const char* proppath )
{
	if ( proppath == NULL ) return NULL ;
	// Ƃ肠A[g擾
	XMLElement* elem = m_pXmlDoc->GetRootElem () ;
	int dcount = GetDirCount (proppath) ;
	int i ;
	const char* nextpath = proppath; 
	char buf[500] ;
	// ċAIɁAړĨGg
	for ( i=0; i<dcount-1; i++ ) {
		nextpath = GetNextDirName ( buf, nextpath ) ;
		elem = elem->SetElem (buf) ;
	}
	// Ō̃pXAvpeBƂĔF
	GetNextDirName ( buf, nextpath ) ;
	char* ret = (char*)elem->GetPropStr (buf) ;
	if ( ret == NULL ) {
		// vpeBȂ 
		elem = elem->SetElem (buf) ;
		ret = (char*)elem->GetContent () ;
	}
	return ret ;
}

int _CFG_Object::Get ( int& prop, const char* proppath )
{
	if ( proppath == NULL ) return -1 ;
	// Ƃ肠A[g擾
	XMLElement* elem = m_pXmlDoc->GetRootElem () ;
	int dcount = GetDirCount (proppath) ;
	int i ;
	const char* nextpath = proppath; 
	char buf[500] ;
	// ċAIɁAړĨGg
	for ( i=0; i<dcount-1; i++ ) {
		nextpath = GetNextDirName ( buf, nextpath ) ;
		elem = elem->SetElem (buf) ;
	}
	// Ō̃pXAvpeBƂĔF
	GetNextDirName ( buf, nextpath ) ;
	char* ret = (char*)elem->GetPropStr (buf) ;
	if ( ret != NULL ) {
		prop = atoi ( ret ) ;
		return 0 ;
	}
	// vpeBȂ 
	elem = elem->SetElem (buf) ;
	ret = (char*)elem->GetContent () ;
	if ( ret != NULL ) {
		prop = atoi ( ret ) ;
		return 0 ;
	}
	return -1 ;
}

int _CFG_Object::Get ( double& prop, const char* proppath )
{
	if ( proppath == NULL ) return -1 ;
	// Ƃ肠A[g擾
	XMLElement* elem = m_pXmlDoc->GetRootElem () ;
	int dcount = GetDirCount (proppath) ;
	int i ;
	const char* nextpath = proppath; 
	char buf[500] ;
	// ċAIɁAړĨGg
	for ( i=0; i<dcount-1; i++ ) {
		nextpath = GetNextDirName ( buf, nextpath ) ;
		elem = elem->SetElem (buf) ;
	}
	// Ō̃pXAvpeBƂĔF
	GetNextDirName ( buf, nextpath ) ;
	char* ret = (char*)elem->GetPropStr (buf) ;
	if ( ret != NULL ) {
		// UTF-32֕ϊ
		prop = atof ( ret ) ;
		return 0 ;
	}
	// vpeBȂ 
	elem = elem->SetElem (buf) ;
	ret = (char*)elem->GetContent () ;
	if ( ret != NULL ) {
		prop = atof ( ret ) ;
		return 0 ;
	}
	return -1 ;
}

/* rcg06192001 get linked library's version. */
const SDL_version *CFG_Linked_Version(void)
{
	static SDL_version linked_version;
	SDL_CFG_VERSION(&linked_version);
	return(&linked_version);
}

CFG_Object* CFG_LoadRW(SDL_RWops* src)
{
	if ( src == NULL ) return NULL ;
	_CFG_Object* obj = new _CFG_Object ( src ) ;
	if ( obj->Init () != 0 ) {
		delete obj ;
		return NULL ;
	}
	return obj ;
}

void CFG_Free(CFG_Object* obj)
{
	if ( obj != NULL ) delete obj ;
}

int CFG_SetString ( CFG_Object* obj, const char* proppath, const char* propval) 
{
	if ( obj == NULL ) return -1 ;
	return 	obj->Set ( proppath, propval ) ;
}

int CFG_SetInteger (CFG_Object* obj, const char* proppath, int propval )
{
	if ( obj == NULL ) return -1 ;
	return 	obj->Set ( proppath, propval ) ;
}

int CFG_SetDouble (CFG_Object* obj, const char* proppath, double propval )
{
	if ( obj == NULL ) return -1 ;
	return 	obj->Set ( proppath, propval ) ;
}

const char* CFG_GetString ( CFG_Object* obj, const char* proppath ) 
{
	if ( obj == NULL ) return NULL ;
	return 	obj->Get ( proppath ) ;
}

int CFG_GetInteger (CFG_Object* obj, const char* proppath, int* prop  )
{
	if ( obj == NULL || prop == NULL ) return -1 ;
	return 	obj->Get ( *prop, proppath ) ;
}

int CFG_GetDouble (CFG_Object* obj, const char* proppath, double* prop )
{
	if ( obj == NULL || prop == NULL ) return -1 ;
	return 	obj->Get ( *prop, proppath ) ;
}

#include <windows.h>

BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{
    return TRUE;
}