/*
    SDL_cfg:  An configuration file parser based on the SDL library
    Copyright (C) 2001-2007 kr2

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    kr2
    ee12054g@hotmail.co.jp
*/
#include "XMLDocument.hpp"
#include <iostream>

XMLDocument::XMLDocument (){}

int	XMLDocument::InputReadCallback		(void * context, 
					 char * buffer, 
					 int len)
{
	return SDL_RWread((SDL_RWops*)context, buffer, sizeof(char), len) ;
}

int	XMLDocument::InputCloseCallback		(void * context)
{
	return 0 ;
}

int	XMLDocument::OutputWriteCallback		(void * context, 
					 const char * buffer, 
					 int len)
{
	return SDL_RWwrite((SDL_RWops*)context, buffer, sizeof(char), len ) ;
}

int	XMLDocument::OutputCloseCallback		(void * context)
{
	return 0 ;
}

// http://xmlsoft.org/html/libxml-parser.html#xmlReadIO //
XMLDocument::XMLDocument (SDL_RWops* rwops)
{
	m_pSrcRW = rwops ;
    /*parse the file and get the DOM */
    doc = xmlReadIO		(InputReadCallback, 
					 InputCloseCallback, 
					 m_pSrcRW, 
					 NULL, 
					 "UTF-8", 
					 XML_PARSE_NOWARNING|XML_PARSE_NOERROR) ;
    if ( doc != NULL ) {
        /*Get the root element node */
        root_element = new XMLElement ( xmlDocGetRootElement(doc), NULL ) ;
    }else{
        // ファイルが無い場合は、新規作成
		if ( CreateNewDocument () ) {
			Save () ;
		}
    }
}

bool XMLDocument::CreateNewDocument ()
{
    doc = xmlNewDoc(BAD_CAST "1.0");
	if ( doc == NULL ) return false ;
    root_element = new XMLElement( xmlNewNode( NULL, BAD_CAST "root" ), NULL ) ;
    xmlDocSetRootElement( doc, root_element->node ) ;
	return true ;
}

XMLDocument::~XMLDocument ()
{
    /* free xml element */
    delete root_element ;
    /*free the document */
    xmlFreeDoc(doc);
}

void XMLDocument::Save ()
{
	SDL_RWseek(m_pSrcRW, 0, SEEK_SET ) ;
	xmlOutputBuffer* buf = xmlOutputBufferCreateIO (
		OutputWriteCallback,
		OutputCloseCallback,
		m_pSrcRW,
		NULL ) ;
	xmlSaveFormatFileTo(buf, doc, "UTF-8", 1) ;
}
