/*
    SDL_cfg:  An configuration file parser based on the SDL library
    Copyright (C) 2001-2007 kr2

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    kr2
    ee12054g@hotmail.co.jp
*/
#ifndef __XMLDOCUMENT_HPP__
#define __XMLDOCUMENT_HPP__

#include <SDL.h>
#include <libxml/xmlreader.h>
#include <libxml/tree.h>

#include "XMLElement.hpp"

#ifdef _MSC_VER
#pragma comment (lib, "libxml2.lib" ) 
#endif


class XMLDocument {
private :
    xmlDoc *doc ;
    XMLElement* root_element ;
	SDL_RWops* m_pSrcRW ;
	
	bool CreateNewDocument () ;
public :
	XMLDocument (SDL_RWops* rwops) ;   
    ~XMLDocument () ;   
    XMLElement* GetRootElem () { return root_element ; }
    void Save () ;

	/* xmlReadIOで用いるコールバック */
	static int	InputReadCallback		(void * context, 
					 char * buffer, 
					 int len) ;
	static int	InputCloseCallback		(void * context) ;

	/* xmlOutputBufferCreateIOで用いるコールバック */
	static int	OutputWriteCallback		(void * context, 
					 const char * buffer, 
					 int len) ;
	static int	OutputCloseCallback		(void * context) ;
private :
    XMLDocument();
} ;


#endif // __XMLDOCUMENT_HPP__
