#include <stdio.h>
#include "SDL_cfg.h"

#include <SDL.h>

#ifdef _MSC_VER
#pragma comment(lib,"SDL.lib")
#pragma comment(lib,"SDLmain.lib")
#ifdef _DEBUG
#define _CRTDBG_MAP_ALLOC
#include <stdlib.h>
#include <crtdbg.h>
#endif
#endif

int main(int argc, char *argv[])
{
	CFG_Object* obj ;
	int width ;
#ifdef _MSC_VER
#ifdef _DEBUG
	int tmpDbgFlag;
	_CrtSetReportMode( _CRT_ERROR, _CRTDBG_MODE_FILE );
	_CrtSetReportFile( _CRT_ERROR, _CRTDBG_FILE_STDOUT );
	tmpDbgFlag = _CrtSetDbgFlag(_CRTDBG_REPORT_FLAG);
	tmpDbgFlag |= _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF;
	_CrtSetDbgFlag(tmpDbgFlag);
#endif
#endif

	if ( argc < 1 ) return 0 ;
	SDL_Init(SDL_INIT_EVERYTHING);

	obj = CFG_Load ( "main.xml" ) ;
	if ( obj == NULL ) return 0 ;

	CFG_GetInteger ( obj, "/Test/Window/width", &width ) ;
	printf ( "/Test/Window/width=%d\n", width ) ;
	CFG_SetInteger ( obj, "/Test/Window/width", 200 ) ;
	CFG_GetInteger ( obj, "/Test/Window/width", &width ) ;
	printf ( "/Test/Window/width=%d\n", width ) ;
	CFG_Free(obj) ;

	getchar () ;

	SDL_Quit();
	return(0);
}
