/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import jp.livewell.baby.db.ConnectionPool;
import jp.livewell.baby.db.StatementFactory;
import jp.livewell.baby.db.StatementManager;
import jp.livewell.baby.db.StatementPool;
import jp.livewell.baby.pool.Bag;
import jp.livewell.baby.pool.FastBag;
import jp.livewell.baby.pool.InfoBase;
import jp.livewell.baby.pool.Pool;

public class ConnectionBag
extends FastBag
implements Connection {
    protected final boolean useStatementPool_;
    protected final StatementManager statementManager_;
    public static final int TRANSACTION_NONE = 0;
    public static final int TRANSACTION_READ_UNCOMMITTED = 1;
    public static final int TRANSACTION_READ_COMMITTED = 2;
    public static final int TRANSACTION_REPEATABLE_READ = 4;
    public static final int TRANSACTION_SERIALIZABLE = 8;

    protected ConnectionBag(Info info, ConnectionPool pool, Pool.Key activateKey, Connection content, StatementPool.Info statementPoolInfo) {
        super((Bag.Info)info, pool, activateKey, (Object)content);
        this.useStatementPool_ = statementPoolInfo != null ? info.isUseStatementPool() : false;
        if (this.useStatementPool_) {
            StatementManager manager;
            StatementFactory.Info stfInfo = (StatementFactory.Info)statementPoolInfo.getFactoryInfo();
            stfInfo.connectionBag_ = this;
            try {
                manager = new StatementManager(statementPoolInfo);
            }
            catch (Exception e) {
                manager = null;
                e.printStackTrace();
            }
            this.statementManager_ = manager;
        } else {
            this.statementManager_ = null;
        }
    }

    public Object crack() {
        if (this.isCracked()) {
            return null;
        }
        StatementManager statementManager = this.statementManager_;
        synchronized (statementManager) {
            this.statementManager_.takeBackAll();
            this.statementManager_.closeAll();
        }
        Connection conn = (Connection)super.crack();
        if (conn == null) {
            return null;
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return conn;
    }

    public boolean ping() {
        try {
            return !((Connection)this.content_).isClosed();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void clearWarnings() throws SQLException {
        ((Connection)this.getContent()).clearWarnings();
    }

    public void close() throws SQLException {
        if (this.useStatementPool_) {
            try {
                this.statementManager_.takeBackAll();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.release();
        Connection con = (Connection)this.content_;
        if (!con.getAutoCommit()) {
            con.setAutoCommit(true);
        }
    }

    public void commit() throws SQLException {
        ((Connection)this.getContent()).commit();
    }

    public Statement createStatement() throws SQLException {
        if (this.useStatementPool_) {
            return this.statementManager_.createStatement();
        }
        return ((Connection)this.getContent()).createStatement();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.useStatementPool_) {
            return this.statementManager_.createStatement(resultSetType, resultSetConcurrency);
        }
        return ((Connection)this.getContent()).createStatement(resultSetType, resultSetConcurrency);
    }

    public String getCatalog() throws SQLException {
        return ((Connection)this.getContent()).getCatalog();
    }

    public boolean getAutoCommit() throws SQLException {
        return ((Connection)this.getContent()).getAutoCommit();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return ((Connection)this.getContent()).getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        return ((Connection)this.getContent()).getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        return ((Connection)this.getContent()).getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        return ((Connection)this.getContent()).getWarnings();
    }

    public boolean isClosed() throws SQLException {
        if (this.isActive_) {
            return ((Connection)this.getContent()).isClosed();
        }
        return true;
    }

    public boolean isReadOnly() throws SQLException {
        return ((Connection)this.getContent()).isReadOnly();
    }

    public String nativeSQL(String sql) throws SQLException {
        return ((Connection)this.getContent()).nativeSQL(sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.useStatementPool_) {
            return this.statementManager_.prepareCall(sql);
        }
        return ((Connection)this.getContent()).prepareCall(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.useStatementPool_) {
            return this.statementManager_.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        return ((Connection)this.getContent()).prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.useStatementPool_) {
            return this.statementManager_.prepareStatement(sql);
        }
        return ((Connection)this.getContent()).prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.useStatementPool_) {
            return this.statementManager_.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        return ((Connection)this.getContent()).prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public void rollback() throws SQLException {
        ((Connection)this.getContent()).rollback();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        ((Connection)this.getContent()).setAutoCommit(autoCommit);
    }

    public void setCatalog(String catalog) throws SQLException {
        ((Connection)this.getContent()).setCatalog(catalog);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        ((Connection)this.getContent()).setReadOnly(readOnly);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        ((Connection)this.getContent()).setTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        ((Connection)this.getContent()).setTypeMap(map);
    }

    public static class Info
    extends Bag.Info {
        public static final String PROP_AUTO_UPDATE_NULL = "autoUpdateNull";
        public static final String PROP_USE_STATEMENT_POOL = "useStatementPool";
        boolean autoUpdateNull_;
        boolean useStatementPool_;

        public Info() {
        }

        public Info(Info info) {
            super(info);
        }

        public Info(Map props) {
            super(props);
        }

        public Info(Map props, Map defaults) {
            super(props, defaults);
        }

        public void clear() {
            try {
                super.clear();
                Object var2_1 = null;
                this.autoUpdateNull_ = false;
                this.useStatementPool_ = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.autoUpdateNull_ = false;
                this.useStatementPool_ = false;
                throw throwable;
            }
        }

        protected Object clone() {
            return new Info(this);
        }

        protected void copy(InfoBase info) {
            super.copy(info);
            Info inf = (Info)info;
            this.autoUpdateNull_ = inf.autoUpdateNull_;
            this.useStatementPool_ = inf.useStatementPool_;
        }

        protected void setValues(Map props) throws Exception {
            super.setValues(props);
            this.autoUpdateNull_ = this.getBoolean(props.get(PROP_AUTO_UPDATE_NULL));
            this.useStatementPool_ = this.getBoolean(props.get(PROP_USE_STATEMENT_POOL));
        }

        protected StringBuffer toStringBuffer() {
            StringBuffer buf = super.toStringBuffer();
            buf.append(" auto update null = ").append(this.autoUpdateNull_).append("\n use statement pool = ").append(this.useStatementPool_).append("\n");
            return buf;
        }

        public boolean isAutoUpdateNull() {
            return this.getBoolean(PROP_AUTO_UPDATE_NULL);
        }

        public boolean isUseStatementPool() {
            return this.getBoolean(PROP_USE_STATEMENT_POOL);
        }
    }
}

