/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.db;

import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import jp.livewell.baby.db.ConnectionBag;
import jp.livewell.baby.db.ConnectionFactory;
import jp.livewell.baby.pool.Bag;
import jp.livewell.baby.pool.Factory;
import jp.livewell.baby.pool.PoolInfoParser;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ConnectionPoolInfoParser
extends PoolInfoParser {
    public static final String TAG_JDBC = "jdbc";
    public static final String TAG_DRIVER = "driver";
    public static final String TAG_URI = "uri";
    public static final String TAG_USER = "user";
    public static final String TAG_PASSWORD = "password";
    public static final String TAG_CONNECTION = "connection";
    public static final String TAG_PROPERTY = "property";
    static /* synthetic */ Class class$jp$livewell$baby$db$ConnectionFactory;

    protected void addBagProperty(Element elm, Map props) {
        if (elm == null) {
            return;
        }
        String tagName = elm.getTagName();
        if (tagName.equals(TAG_PROPERTY)) {
            props.put(elm.getAttribute("name"), elm.getAttribute("value"));
        }
    }

    protected void addFactoryProperty(Element elm, Map props) {
        String tagName;
        if (elm == null) {
            return;
        }
        Map ext = (Map)props.get("properties");
        if (ext == null) {
            ext = new Properties();
            props.put("properties", ext);
        }
        if ((tagName = elm.getTagName()).equals(TAG_DRIVER)) {
            Text tx = this.getFirstText(elm);
            if (tx != null) {
                props.put("driverName", tx.getNodeValue());
            }
        } else if (tagName.equals(TAG_URI)) {
            Text tx = this.getFirstText(elm);
            if (tx != null) {
                props.put(TAG_URI, tx.getNodeValue());
            }
        } else if (tagName.equals(TAG_USER)) {
            Text tx = this.getFirstText(elm);
            if (tx != null) {
                ext.put(TAG_USER, tx.getNodeValue());
            }
        } else if (tagName.equals(TAG_PASSWORD)) {
            Text tx = this.getFirstText(elm);
            if (tx != null) {
                ext.put(TAG_PASSWORD, tx.getNodeValue());
            }
        } else if (tagName.equals(TAG_PROPERTY)) {
            ext.put(elm.getAttribute("name"), elm.getAttribute("value"));
        }
    }

    protected Bag.Info createBagInfo(Element factoryElm) {
        return new ConnectionBag.Info(this.parseBagProps(factoryElm, TAG_CONNECTION));
    }

    protected Factory.Info createFactoryInfo(Element poolElm) {
        return new ConnectionFactory.Info(this.parseFactoryProps(poolElm, TAG_JDBC));
    }

    protected Map parsePoolProps(Element poolElm) {
        Map props = super.parsePoolProps(poolElm);
        String facNm = (String)props.get("factoryClass");
        if (facNm != null && !facNm.equals("")) {
            return props;
        }
        props.put("factoryClass", (class$jp$livewell$baby$db$ConnectionFactory == null ? (class$jp$livewell$baby$db$ConnectionFactory = ConnectionPoolInfoParser.class$("jp.livewell.baby.db.ConnectionFactory")) : class$jp$livewell$baby$db$ConnectionFactory).getName());
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

