/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.db;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import jp.livewell.baby.db.ConnectionPool;
import jp.livewell.baby.db.ConnectionPoolInfoParser;
import jp.livewell.baby.pool.Pool;

public class DataSourceLoader {
    public static final String DEFAULT_POOL_INFO_XML = "babyPool.xml";
    private ConnectionPoolInfoParser parser_;

    public DataSourceLoader() {
        try {
            this.parser_ = new ConnectionPoolInfoParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public Map loadDataSources() {
        return this.loadDataSources(DEFAULT_POOL_INFO_XML);
    }

    public Map loadDataSources(String resourceName) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL place = loader.getResource(resourceName);
        HashMap<String, ConnectionPool> ret = new HashMap<String, ConnectionPool>();
        if (place != null) {
            try {
                Pool.Info[] nInfos = this.parser_.parseInfos(place);
                int i = nInfos.length;
                while (i-- > 0) {
                    ConnectionPool pool = new ConnectionPool(nInfos[i]);
                    ret.put(pool.getName(), pool);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(this.getClass().toString() + " :: load DataSource failed.");
            }
        }
        return ret;
    }
}

