/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.db;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import jp.livewell.baby.db.StatementBag;

public class ResultSetWrap
implements ResultSet {
    protected boolean useAutoUpdateNull_ = false;
    protected ResultSet result_ = null;
    protected StatementBag statement_;

    public ResultSetWrap(ResultSet res, StatementBag statement, boolean autoUpdateNull) {
        if (res == null) {
            throw new NullPointerException(this.getClass().toString() + "can't create ResultSetWrap from null ResultSet");
        }
        this.result_ = res;
        if (statement == null) {
            throw new NullPointerException(this.getClass().toString() + "can't create ResultSetWrap from null Statement");
        }
        this.statement_ = statement;
        this.useAutoUpdateNull_ = autoUpdateNull;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void close() throws SQLException {
        try {
            if (this.result_ != null) {
                this.result_.close();
            }
            Object var2_1 = null;
            this.result_ = null;
            this.statement_ = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.result_ = null;
            this.statement_ = null;
            throw throwable;
        }
    }

    private boolean _tryUpdatedNull(int columnIndex, Object val) throws SQLException {
        if (val == null && this.useAutoUpdateNull_) {
            this.result_.updateNull(columnIndex);
            return true;
        }
        return false;
    }

    private boolean _tryUpdatedNull(String columnName, Object val) throws SQLException {
        if (val == null && this.useAutoUpdateNull_) {
            this.result_.updateNull(columnName);
            return true;
        }
        return false;
    }

    public Byte getByteObj(int columnIndex) throws SQLException {
        byte ans = this.result_.getByte(columnIndex);
        if (this.result_.wasNull()) {
            return null;
        }
        return new Byte(ans);
    }

    public void updateByteObj(int columnIndex, Byte val) throws SQLException {
        if (this._tryUpdatedNull(columnIndex, (Object)val)) {
            return;
        }
        this.result_.updateByte(columnIndex, (byte)val);
    }

    public Integer getInteger(int columnIndex) throws SQLException {
        int ans = this.result_.getInt(columnIndex);
        if (this.result_.wasNull()) {
            return null;
        }
        return new Integer(ans);
    }

    public void updateInteger(int columnIndex, Integer val) throws SQLException {
        if (this._tryUpdatedNull(columnIndex, (Object)val)) {
            return;
        }
        this.result_.updateInt(columnIndex, (int)val);
    }

    public Long getLongObj(int columnIndex) throws SQLException {
        long ans = this.result_.getLong(columnIndex);
        if (this.result_.wasNull()) {
            return null;
        }
        return new Long(ans);
    }

    public void updateLongObj(int columnIndex, Long val) throws SQLException {
        if (this._tryUpdatedNull(columnIndex, (Object)val)) {
            return;
        }
        this.result_.updateLong(columnIndex, (long)val);
    }

    protected ResultSet _getReal() {
        return this.result_;
    }

    public boolean absolute(int row) throws SQLException {
        return this.result_.absolute(row);
    }

    public void afterLast() throws SQLException {
        this.result_.afterLast();
    }

    public void beforeFirst() throws SQLException {
        this.result_.beforeFirst();
    }

    public void cancelRowUpdates() throws SQLException {
        this.result_.cancelRowUpdates();
    }

    public void clearWarnings() throws SQLException {
        this.result_.clearWarnings();
    }

    public void deleteRow() throws SQLException {
        this.result_.deleteRow();
    }

    public int findColumn(String columnName) throws SQLException {
        return this.result_.findColumn(columnName);
    }

    public boolean first() throws SQLException {
        return this.result_.first();
    }

    public int getConcurrency() throws SQLException {
        return this.result_.getConcurrency();
    }

    public String getCursorName() throws SQLException {
        return this.result_.getCursorName();
    }

    public int getFetchDirection() throws SQLException {
        return this.result_.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.result_.getFetchSize();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.result_.getMetaData();
    }

    public int getRow() throws SQLException {
        return this.result_.getRow();
    }

    public Statement getStatement() throws SQLException {
        return this.statement_;
    }

    public int getType() throws SQLException {
        return this.result_.getType();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.result_.getWarnings();
    }

    public void insertRow() throws SQLException {
        this.result_.insertRow();
    }

    public boolean isAfterLast() throws SQLException {
        return this.result_.isAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.result_.isBeforeFirst();
    }

    public boolean isFirst() throws SQLException {
        return this.result_.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.result_.isLast();
    }

    public boolean last() throws SQLException {
        return this.result_.last();
    }

    public void moveToCurrentRow() throws SQLException {
        this.result_.moveToCurrentRow();
    }

    public void moveToInsertRow() throws SQLException {
        this.result_.moveToInsertRow();
    }

    public boolean next() throws SQLException {
        return this.result_.next();
    }

    public boolean previous() throws SQLException {
        return this.result_.previous();
    }

    public void refreshRow() throws SQLException {
        this.result_.refreshRow();
    }

    public boolean relative(int rows) throws SQLException {
        return this.result_.relative(rows);
    }

    public boolean rowDeleted() throws SQLException {
        return this.result_.rowDeleted();
    }

    public boolean rowInserted() throws SQLException {
        return this.result_.rowInserted();
    }

    public boolean rowUpdated() throws SQLException {
        return this.result_.rowUpdated();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.result_.setFetchDirection(direction);
    }

    public void setFetchSize(int size) throws SQLException {
        this.result_.setFetchSize(size);
    }

    public void updateRow() throws SQLException {
        this.result_.updateRow();
    }

    public Array getArray(int columnIndex) throws SQLException {
        return this.result_.getArray(columnIndex);
    }

    public Array getArray(String columnName) throws SQLException {
        return this.result_.getArray(columnName);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.result_.getAsciiStream(columnIndex);
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.result_.getAsciiStream(columnName);
    }

    public void updateAsciiStream(int columnIndex, InputStream val, int length) throws SQLException {
        if (this._tryUpdatedNull(columnIndex, (Object)val)) {
            return;
        }
        this.result_.updateAsciiStream(columnIndex, val, length);
    }

    public void updateAsciiStream(String columnName, InputStream val, int length) throws SQLException {
        if (this._tryUpdatedNull(columnName, (Object)val)) {
            return;
        }
        this.result_.updateAsciiStream(columnName, val, length);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.result_.getBinaryStream(columnIndex);
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.result_.getBinaryStream(columnName);
    }

    public void updateBinaryStream(int columnIndex, InputStream val, int length) throws SQLException {
        if (this._tryUpdatedNull(columnIndex, (Object)val)) {
            return;
        }
        this.result_.updateBinaryStream(columnIndex, val, length);
    }

    public void updateBinaryStream(String columnName, InputStream val, int length) throws SQLException {
        if (this._tryUpdatedNull(columnName, (Object)val)) {
            return;
        }
        this.result_.updateBinaryStream(columnName, val, length);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.result_.getBigDecimal(columnIndex);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.result_.getBigDecimal(columnName);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.result_.getBigDecimal(columnIndex, scale);
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.result_.getBigDecimal(columnName, scale);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal val) throws SQLException {
        if (this._tryUpdatedNull(columnIndex, (Object)val)) {
            return;
        }
        this.result_.updateBigDecimal(columnIndex, val);
    }

    public void updateBigDecimal(String columnName, BigDecimal val) throws SQLException {
        if (this._tryUpdatedNull(columnName, (Object)val)) {
            return;
        }
        this.result_.updateBigDecimal(columnName, val);
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        return this.result_.getBlob(columnIndex);
    }

    public Blob getBlob(String columnName) throws SQLException {
        return this.result_.getBlob(columnName);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.result_.getBoolean(columnIndex);
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.result_.getBoolean(columnName);
    }

    public void updateBoolean(int columnIndex, boolean val) throws SQLException {
        this.result_.updateBoolean(columnIndex, val);
    }

    public void updateBoolean(String columnName, boolean val) throws SQLException {
        this.result_.updateBoolean(columnName, val);
    }

    public byte getByte(int columnIndex) throws SQLException {
        return this.result_.getByte(columnIndex);
    }

    public byte getByte(String columnName) throws SQLException {
        return this.result_.getByte(columnName);
    }

    public void updateByte(int columnIndex, byte val) throws SQLException {
        this.result_.updateByte(columnIndex, val);
    }

    public void updateByte(String columnName, byte val) throws SQLException {
        this.result_.updateByte(columnName, val);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.result_.getBytes(columnIndex);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.result_.getBytes(columnName);
    }

    public void updateBytes(int columnIndex, byte[] val) throws SQLException {
        if (this._tryUpdatedNull(columnIndex, (Object)val)) {
            return;
        }
        this.result_.updateBytes(columnIndex, val);
    }

    public void updateBytes(String columnName, byte[] val) throws SQLException {
        if (this._tryUpdatedNull(columnName, (Object)val)) {
            return;
        }
        this.result_.updateBytes(columnName, val);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.result_.getCharacterStream(columnIndex);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.result_.getCharacterStream(columnName);
    }

    public void updateCharacterStream(int columnIndex, Reader reader, int length) throws SQLException {
        if (this._tryUpdatedNull(columnIndex, (Object)reader)) {
            return;
        }
        this.result_.updateCharacterStream(columnIndex, reader, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        if (this._tryUpdatedNull(columnName, (Object)reader)) {
            return;
        }
        this.result_.updateCharacterStream(columnName, reader, length);
    }

    public Clob getClob(int columnIndex) throws SQLException {
        return this.result_.getClob(columnIndex);
    }

    public Clob getClob(String columnName) throws SQLException {
        return this.result_.getClob(columnName);
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.result_.getDate(columnIndex);
    }

    public Date getDate(String columnName) throws SQLException {
        return this.result_.getDate(columnName);
    }

    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        return this.result_.getDate(columnIndex, calendar);
    }

    public Date getDate(String columnName, Calendar calendar) throws SQLException {
        return this.result_.getDate(columnName, calendar);
    }

    public void updateDate(int columnIndex, Date val) throws SQLException {
        if (this._tryUpdatedNull(columnIndex, (Object)val)) {
            return;
        }
        this.result_.updateDate(columnIndex, val);
    }

    public void updateDate(String columnName, Date val) throws SQLException {
        if (this._tryUpdatedNull(columnName, (Object)val)) {
            return;
        }
        this.result_.updateDate(columnName, val);
    }

    public double getDouble(int columnIndex) throws SQLException {
        return this.result_.getDouble(columnIndex);
    }

    public double getDouble(String columnName) throws SQLException {
        return this.result_.getDouble(columnName);
    }

    public void updateDouble(int columnIndex, double val) throws SQLException {
        this.result_.updateDouble(columnIndex, val);
    }

    public void updateDouble(String columnName, double val) throws SQLException {
        this.result_.updateDouble(columnName, val);
    }

    public float getFloat(int columnIndex) throws SQLException {
        return this.result_.getFloat(columnIndex);
    }

    public float getFloat(String columnName) throws SQLException {
        return this.result_.getFloat(columnName);
    }

    public void updateFloat(int columnIndex, float val) throws SQLException {
        this.result_.updateFloat(columnIndex, val);
    }

    public void updateFloat(String columnName, float val) throws SQLException {
        this.result_.updateFloat(columnName, val);
    }

    public int getInt(int columnIndex) throws SQLException {
        return this.result_.getInt(columnIndex);
    }

    public int getInt(String columnName) throws SQLException {
        return this.result_.getInt(columnName);
    }

    public void updateInt(int columnIndex, int val) throws SQLException {
        this.result_.updateInt(columnIndex, val);
    }

    public void updateInt(String columnName, int val) throws SQLException {
        this.result_.updateInt(columnName, val);
    }

    public long getLong(int columnIndex) throws SQLException {
        return this.result_.getLong(columnIndex);
    }

    public long getLong(String columnName) throws SQLException {
        return this.result_.getLong(columnName);
    }

    public void updateLong(int columnIndex, long val) throws SQLException {
        this.result_.updateLong(columnIndex, val);
    }

    public void updateLong(String columnName, long val) throws SQLException {
        this.result_.updateLong(columnName, val);
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.result_.updateNull(columnIndex);
    }

    public void updateNull(String columnName) throws SQLException {
        this.result_.updateNull(columnName);
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this.result_.getObject(columnIndex);
    }

    public Object getObject(String columnName) throws SQLException {
        return this.result_.getObject(columnName);
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        return this.result_.getObject(columnIndex, map);
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        return this.result_.getObject(columnName, map);
    }

    public void updateObject(int columnIndex, Object val) throws SQLException {
        if (this._tryUpdatedNull(columnIndex, val)) {
            return;
        }
        this.result_.updateObject(columnIndex, val);
    }

    public void updateObject(String columnName, Object val) throws SQLException {
        if (this._tryUpdatedNull(columnName, val)) {
            return;
        }
        this.result_.updateObject(columnName, val);
    }

    public void updateObject(int columnIndex, Object val, int scale) throws SQLException {
        if (this._tryUpdatedNull(columnIndex, val)) {
            return;
        }
        this.result_.updateObject(columnIndex, val, scale);
    }

    public void updateObject(String columnName, Object val, int scale) throws SQLException {
        if (this._tryUpdatedNull(columnName, val)) {
            return;
        }
        this.result_.updateObject(columnName, val, scale);
    }

    public Ref getRef(int columnIndex) throws SQLException {
        return this.result_.getRef(columnIndex);
    }

    public Ref getRef(String columnName) throws SQLException {
        return this.result_.getRef(columnName);
    }

    public short getShort(int columnIndex) throws SQLException {
        return this.result_.getShort(columnIndex);
    }

    public short getShort(String columnName) throws SQLException {
        return this.result_.getShort(columnName);
    }

    public void updateShort(int columnIndex, short val) throws SQLException {
        this.result_.updateShort(columnIndex, val);
    }

    public void updateShort(String columnName, short val) throws SQLException {
        this.result_.updateShort(columnName, val);
    }

    public String getString(int columnIndex) throws SQLException {
        return this.result_.getString(columnIndex);
    }

    public String getString(String columnName) throws SQLException {
        return this.result_.getString(columnName);
    }

    public void updateString(int columnIndex, String val) throws SQLException {
        if (this._tryUpdatedNull(columnIndex, (Object)val)) {
            return;
        }
        this.result_.updateString(columnIndex, val);
    }

    public void updateString(String columnName, String val) throws SQLException {
        if (this._tryUpdatedNull(columnName, (Object)val)) {
            return;
        }
        this.result_.updateString(columnName, val);
    }

    public Time getTime(int columnIndex) throws SQLException {
        return this.result_.getTime(columnIndex);
    }

    public Time getTime(String columnName) throws SQLException {
        return this.result_.getTime(columnName);
    }

    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        return this.result_.getTime(columnIndex, calendar);
    }

    public Time getTime(String columnName, Calendar calendar) throws SQLException {
        return this.result_.getTime(columnName, calendar);
    }

    public void updateTime(int columnIndex, Time val) throws SQLException {
        if (this._tryUpdatedNull(columnIndex, (Object)val)) {
            return;
        }
        this.result_.updateTime(columnIndex, val);
    }

    public void updateTime(String columnName, Time val) throws SQLException {
        if (this._tryUpdatedNull(columnName, (Object)val)) {
            return;
        }
        this.result_.updateTime(columnName, val);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.result_.getTimestamp(columnIndex);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.result_.getTimestamp(columnName);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        return this.result_.getTimestamp(columnIndex, calendar);
    }

    public Timestamp getTimestamp(String columnName, Calendar calendar) throws SQLException {
        return this.result_.getTimestamp(columnName, calendar);
    }

    public void updateTimestamp(int columnIndex, Timestamp val) throws SQLException {
        if (this._tryUpdatedNull(columnIndex, (Object)val)) {
            return;
        }
        this.result_.updateTimestamp(columnIndex, val);
    }

    public void updateTimestamp(String columnName, Timestamp val) throws SQLException {
        if (this._tryUpdatedNull(columnName, (Object)val)) {
            return;
        }
        this.result_.updateTimestamp(columnName, val);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.result_.getUnicodeStream(columnIndex);
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.result_.getUnicodeStream(columnName);
    }

    public boolean wasNull() throws SQLException {
        return this.result_.wasNull();
    }
}

