/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.db;

import java.sql.Connection;
import java.util.Map;
import jp.livewell.baby.db.CallableStatementBag;
import jp.livewell.baby.db.ConnectionBag;
import jp.livewell.baby.db.PreparedStatementBag;
import jp.livewell.baby.db.StatementBag;
import jp.livewell.baby.db.StatementPool;
import jp.livewell.baby.pool.Bag;
import jp.livewell.baby.pool.Factory;
import jp.livewell.baby.pool.FastBag;
import jp.livewell.baby.pool.FastFactory;
import jp.livewell.baby.pool.FastPool;
import jp.livewell.baby.pool.InfoBase;
import jp.livewell.baby.pool.Pool;

class StatementFactory
extends FastFactory {
    private Bag.Cacher cacher_ = null;

    StatementFactory() {
    }

    public void close() {
        try {
            super.close();
            Object var2_1 = null;
            this.cacher_ = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.cacher_ = null;
            throw throwable;
        }
    }

    public FastBag createNew(FastPool pool, Pool.Key activateKey) throws Exception {
        return this._createNew((StatementPool)pool, (StatementPool.Key)activateKey);
    }

    public void init(Pool pool, Factory.Info info) {
        super.init(pool, info);
        Info inf = (Info)info;
        this.cacher_ = inf.getConnectionBag().getCacher();
    }

    StatementBag createNew(StatementPool pool, StatementPool.Key activateKey) throws Exception {
        return this._createNew(pool, activateKey);
    }

    private StatementBag _createNew(StatementPool pool, StatementPool.Key activateKey) throws Exception {
        ConnectionBag connBag = (ConnectionBag)this.cacher_.get();
        Connection conn = (Connection)connBag.getContent();
        String sql = activateKey.sql_;
        int resType = activateKey.resultSetType_;
        int resConcur = activateKey.resultSetConcurrency_;
        int stmtType = activateKey.statementType_;
        if (stmtType == 0) {
            return new StatementBag((StatementBag.Info)this.info_.getBagInfo(), pool, activateKey, conn.createStatement(resType, resConcur), connBag);
        }
        if (stmtType == 1) {
            return new PreparedStatementBag((StatementBag.Info)this.info_.getBagInfo(), pool, activateKey, conn.prepareStatement(sql, resType, resConcur), connBag);
        }
        if (stmtType == 2) {
            return new CallableStatementBag((StatementBag.Info)this.info_.getBagInfo(), pool, activateKey, conn.prepareCall(sql, resType, resConcur), connBag);
        }
        throw new IllegalArgumentException(this.getClass().toString() + "can't find Statement Type!!");
    }

    static class Info
    extends Factory.Info {
        static final String PROP_CONNECTION_BAG = "connectionBag";
        ConnectionBag connectionBag_;

        Info() {
        }

        Info(Info info) {
            super(info);
        }

        Info(Map props) {
            super(props);
        }

        Info(Map props, Map defaults) {
            super(props, defaults);
        }

        public void clear() {
            try {
                super.clear();
                Object var2_1 = null;
                this.connectionBag_ = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.connectionBag_ = null;
                throw throwable;
            }
        }

        protected Object clone() {
            return new Info(this);
        }

        protected void copy(InfoBase info) {
            super.copy(info);
            Info inf = (Info)info;
            this.connectionBag_ = inf.connectionBag_;
        }

        protected void setValues(Map props) throws Exception {
            super.setValues(props);
            this.connectionBag_ = (ConnectionBag)props.get(PROP_CONNECTION_BAG);
        }

        ConnectionBag getConnectionBag() {
            return this.connectionBag_;
        }
    }
}

