/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.db;

import jp.livewell.baby.db.CallableStatementBag;
import jp.livewell.baby.db.PreparedStatementBag;
import jp.livewell.baby.db.StatementBag;
import jp.livewell.baby.db.StatementFactory;
import jp.livewell.baby.db.StatementPool;
import jp.livewell.baby.pool.HashManager;

class StatementManager
extends HashManager {
    protected final StatementPool.Key shareKey_ = new StatementPool.Key();
    protected final StatementPool.Info info_;
    protected final StatementFactory factory_;

    StatementManager(StatementPool.Info info) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this(info, 11);
    }

    StatementManager(StatementPool.Info info, int bucketSize) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        super(bucketSize);
        this.info_ = info;
        Class facClass = info.getFactoryClass();
        if (facClass == null) {
            throw new IllegalArgumentException(this.getClass().toString() + " :: factory class is null");
        }
        StatementFactory factory = (StatementFactory)facClass.newInstance();
        factory.init(null, info.getFactoryInfo());
        this.factory_ = factory;
    }

    StatementBag createStatement() {
        return this._getPool(null, 1003, 1007, 0).getStatement();
    }

    StatementBag createStatement(int resultSetType, int resultSetConcurrency) {
        return this._getPool(null, resultSetType, resultSetConcurrency, 0).getStatement();
    }

    private StatementPool _getPool(String sql, int resultSetType, int resultSetConcurrency, int statementType) {
        StatementPool pool;
        StatementPool.Key key;
        StatementPool.Key key2 = key = this.shareKey_;
        synchronized (key2) {
            key.sql_ = sql;
            key.resultSetType_ = resultSetType;
            key.resultSetConcurrency_ = resultSetConcurrency;
            key.statementType_ = statementType;
            pool = (StatementPool)this.getPool(key);
            if (pool != null) {
                StatementPool statementPool = pool;
                return statementPool;
            }
            StatementPool.Key newKey = new StatementPool.Key(sql, resultSetType, resultSetConcurrency, statementType);
            StatementPool.Info info = (StatementPool.Info)this.info_.clone();
            info.setActivateKey(newKey);
            try {
                pool = new StatementPool(info, this.factory_);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(this.getClass().toString() + " :: " + e.toString());
            }
            this.putPool(newKey, pool);
        }
        return pool;
    }

    PreparedStatementBag prepareStatement(String sql) {
        return this._getPool(sql, 1003, 1007, 1).getPreparedStatement();
    }

    PreparedStatementBag prepareStatement(String sql, int resultSetType, int resultSetConcurrency) {
        return this._getPool(sql, resultSetType, resultSetConcurrency, 1).getPreparedStatement();
    }

    CallableStatementBag prepareCall(String sql) {
        return this._getPool(sql, 1003, 1007, 1).getCallableStatement();
    }

    CallableStatementBag prepareCall(String sql, int resultSetType, int resultSetConcurrency) {
        return this._getPool(sql, resultSetType, resultSetConcurrency, 1).getCallableStatement();
    }
}

