/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.db;

import java.util.HashMap;
import java.util.Map;
import jp.livewell.baby.db.CallableStatementBag;
import jp.livewell.baby.db.PreparedStatementBag;
import jp.livewell.baby.db.StatementBag;
import jp.livewell.baby.db.StatementFactory;
import jp.livewell.baby.pool.FastPool;
import jp.livewell.baby.pool.Pool;

class StatementPool
extends FastPool {
    StatementPool(Info info, StatementFactory factory) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        super((Pool.Info)info, factory);
    }

    StatementBag getStatement() {
        return (StatementBag)this.takeOut();
    }

    PreparedStatementBag getPreparedStatement() {
        return (PreparedStatementBag)this.takeOut();
    }

    CallableStatementBag getCallableStatement() {
        return (CallableStatementBag)this.takeOut();
    }

    static class Key
    extends Pool.Key
    implements Comparable {
        static final int STATEMENT = 0;
        static final int PREPARED = 1;
        static final int CALLABLE = 2;
        String sql_;
        int resultSetType_;
        int resultSetConcurrency_;
        int statementType_;

        Key() {
            this(null, 1003, 1007, 0);
        }

        Key(Key key) {
            this(key.sql_, key.resultSetType_, key.resultSetConcurrency_, key.statementType_);
        }

        Key(String sql, int resultSetType, int resultSetConcurrency, int statementType) {
            this.sql_ = sql;
            this.resultSetType_ = resultSetType;
            this.resultSetConcurrency_ = resultSetConcurrency;
            this.statementType_ = statementType;
        }

        public int compareTo(Object o) {
            return this._compareTo((Key)o);
        }

        private int _compareTo(Key y) {
            Key x = this;
            int res = 0;
            res = x.statementType_ - y.statementType_;
            if (res != 0) {
                return res;
            }
            if (x.statementType_ != 0 && (res = x.sql_.compareTo(y.sql_)) != 0) {
                return res;
            }
            res = x.resultSetType_ - y.resultSetType_;
            if (res != 0) {
                return res;
            }
            return x.resultSetConcurrency_ - y.resultSetConcurrency_;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                return this._compareTo((Key)o) == 0;
            }
            return false;
        }

        String getSQL() {
            return this.sql_;
        }

        int getResultSetType() {
            return this.resultSetType_;
        }

        int getResultSetConcurrency() {
            return this.resultSetConcurrency_;
        }

        public int getStatementType() {
            return this.statementType_;
        }

        public int hashCode() {
            if (this.sql_ == null) {
                return this.resultSetType_ * 11 + this.resultSetConcurrency_ * 13 + this.statementType_ * 17;
            }
            return this.resultSetType_ * 11 + this.resultSetConcurrency_ * 13 + this.statementType_ * 17 + this.sql_.hashCode();
        }
    }

    static class Info
    extends Pool.Info {
        private static final HashMap DEFAULT_INFO;
        static /* synthetic */ Class class$jp$livewell$baby$db$StatementFactory;

        Info() {
        }

        Info(Info info) {
            super(info);
        }

        Info(Map props) {
            super(props, DEFAULT_INFO);
        }

        Info(Map props, Map defaults) {
            super(props, defaults);
        }

        protected Object clone() {
            return new Info(this);
        }

        void setActivateKey(Key activateKey) {
            this.activateKey_ = activateKey;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("poolName", "statementPool");
            map.put("useMaximum", new Boolean(false));
            map.put("maxSize", new Integer(Integer.MAX_VALUE));
            map.put("useMinimum", new Boolean(false));
            map.put("minSize", new Integer(0));
            map.put("factoryClass", (class$jp$livewell$baby$db$StatementFactory == null ? (class$jp$livewell$baby$db$StatementFactory = Info.class$("jp.livewell.baby.db.StatementFactory")) : class$jp$livewell$baby$db$StatementFactory).getName());
            DEFAULT_INFO = map;
        }
    }
}

