/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool;

import jp.livewell.baby.pool.Bag;
import jp.livewell.baby.pool.Pool;

public abstract class AbstractBag
implements Bag {
    protected Pool.Key activateKey_;
    protected Bag.Cacher cacher_ = null;
    protected Object content_;
    protected Bag.Info info_;
    protected boolean isActive_ = false;
    protected boolean isCracked_ = false;
    protected Pool pool_;

    protected AbstractBag(Bag.Info info, Pool pool, Pool.Key activateKey, Object content) {
        if (content == null) {
            throw new IllegalArgumentException(this.getClass().toString() + "can't create null content Bag!!");
        }
        this.info_ = info;
        this.content_ = content;
        this.activateKey_ = activateKey;
        this.pool_ = pool;
    }

    public boolean activate(Pool.Key activateKey) {
        if (this.isActive_) {
            return false;
        }
        this.isActive_ = this.activateKey_ == activateKey;
        return this.isActive_;
    }

    public Object crack() {
        Object ret;
        if (this.isCracked_) {
            return null;
        }
        if (this.content_ == null) {
            return null;
        }
        AbstractBag abstractBag = this;
        synchronized (abstractBag) {
            if (this.cacher_ != null) {
                this.cacher_.clear();
                this.cacher_ = null;
            }
            this.activateKey_ = null;
            ret = this.content_;
            this.content_ = null;
            this.info_ = null;
            this.isCracked_ = true;
            this.isActive_ = false;
            this.pool_ = null;
        }
        return ret;
    }

    public boolean isActive() {
        return this.isActive_;
    }

    public boolean isCracked() {
        return this.isCracked_;
    }

    public Bag.Cacher getCacher() {
        return this.cacher_;
    }

    public Object getContent() {
        if (this.isActive_) {
            return this.content_;
        }
        throw new IllegalStateException(this.getClass().toString() + " now not active this bag!!");
    }

    public void release() {
        if (!this.isCracked_ && this.isActive_) {
            this.isActive_ = false;
            this.pool_.putBack(this.cacher_);
        } else {
            System.out.println(this.getClass().toString() + "only warn:: maybe already releaced or cracked.");
        }
    }

    protected void finalize() throws Throwable {
        if (this.isCracked_) {
            return;
        }
        if (this.pool_ == null) {
            return;
        }
        this.pool_.wasteBag(this);
    }

    public abstract boolean ping();
}

