/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool;

import jp.livewell.baby.pool.Bag;
import jp.livewell.baby.pool.Factory;
import jp.livewell.baby.pool.Pool;

public abstract class AbstractPool
implements Pool {
    protected final Pool.Key activateKey_;
    protected final Factory factory_;
    protected int maxSize_;
    protected int minSize_;
    protected final String name_;
    protected final boolean autoDust_;
    protected final boolean useCheckBag_;
    protected final boolean useMaximum_;
    protected final boolean useMinimum_;
    protected final boolean useTimeOut_;
    protected final int waitTime_;

    public AbstractPool(Pool.Info info) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this(info, null);
    }

    public AbstractPool(Pool.Info info, Factory factory) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.name_ = info.getName();
        this.useMaximum_ = info.isUseMaximum();
        this.maxSize_ = info.getMaxSize();
        this.useMinimum_ = info.isUseMinimum();
        this.minSize_ = info.getMinSize();
        this.autoDust_ = info.isAutoDust();
        this.useCheckBag_ = info.isUseCheckBag();
        this.useTimeOut_ = info.isUseTimeOut();
        this.waitTime_ = info.getWaitTime();
        Pool.Key actKey = info.getActivateKey();
        if (actKey == null) {
            actKey = new Pool.Key();
        }
        this.activateKey_ = actKey;
        if (factory == null) {
            Class facClass = info.getFactoryClass();
            if (facClass == null) {
                throw new IllegalArgumentException(this.getClass().toString() + " :: factory class is null");
            }
            factory = (Factory)facClass.newInstance();
            factory.init(this, info.getFactoryInfo());
        }
        this.factory_ = factory;
    }

    public void close() {
        try {
            this.clear();
            if (this.factory_ != null) {
                this.factory_.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getMaxSize() {
        return this.maxSize_;
    }

    public int getMinSize() {
        return this.minSize_;
    }

    public String getName() {
        return this.name_;
    }

    public int getWaitTime() {
        return this.waitTime_;
    }

    public boolean isAutoDust() {
        return this.autoDust_;
    }

    public boolean isUseCheckBag() {
        return this.useCheckBag_;
    }

    public boolean isUseMaximum() {
        return this.useMaximum_;
    }

    public boolean isUseMinimum() {
        return this.useMinimum_;
    }

    public boolean isUseTimeOut() {
        return this.useTimeOut_;
    }

    protected boolean activateBag(Bag bag) {
        try {
            if (this.useCheckBag_ && !bag.ping()) {
                return false;
            }
            return bag.activate(this.activateKey_);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public abstract void wasteBag(Bag var1);

    public abstract Bag takeOut();

    public abstract void takeBackAll();

    public abstract boolean putBack(Bag.Cacher var1);

    public abstract int getStockSize();

    public abstract int getSize();

    public abstract int getLendSize();

    public abstract void clear();
}

