/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import jp.livewell.baby.pool.InfoBase;
import jp.livewell.baby.pool.Pool;

public interface Bag {
    public boolean activate(Pool.Key var1);

    public Object crack();

    public boolean isActive();

    public boolean isCracked();

    public Cacher getCacher();

    public Object getContent();

    public boolean ping();

    public void release();

    public static class Cacher
    extends SoftReference {
        private int hashCode_ = super.hashCode();
        protected Object strongRef_;

        public Cacher(Bag bag) {
            super(bag);
        }

        public void clear() {
            super.clear();
            this.strongRef_ = null;
        }

        public final Bag getBag() {
            return (Bag)super.get();
        }

        public final int hashCode() {
            return this.hashCode_;
        }

        public final boolean isValid() {
            return this.get() != null;
        }

        public final void keep() {
            this.strongRef_ = this.get();
        }

        public final void unKeep() {
            this.strongRef_ = null;
        }
    }

    public static class Info
    extends InfoBase {
        private static final HashMap DEFAULT_INFO = new HashMap();

        public Info() {
        }

        public Info(Info info) {
            this.copy(info);
        }

        public Info(Map props) {
            super(props, DEFAULT_INFO);
        }

        public Info(Map props, Map defaults) {
            super(props, defaults);
        }

        protected Object clone() {
            return new Info(this);
        }
    }
}

