/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool;

import jp.livewell.baby.pool.AbstractPool;
import jp.livewell.baby.pool.Bag;
import jp.livewell.baby.pool.FastBag;
import jp.livewell.baby.pool.FastFactory;
import jp.livewell.baby.pool.Pool;

public class FastPool
extends AbstractPool {
    protected final FastBag.LinkedCacher lendHeader_ = new FastBag.LinkedCacher(null);
    private final Lock lock_ = new Lock();
    protected final FastBag.LinkedCacher stockHeader_ = new FastBag.LinkedCacher(null);
    protected int total_;
    private int waitCount_;

    public FastPool(Pool.Info info) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this(info, null);
    }

    public FastPool(Pool.Info info, FastFactory factory) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        super(info, factory);
    }

    public void close() {
        try {
            super.close();
            Object var2_1 = null;
            this.lendHeader_.clear();
            this.stockHeader_.clear();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lendHeader_.clear();
            this.stockHeader_.clear();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void clear() {
        FastBag bag = null;
        Lock lock = this.lock_;
        synchronized (lock) {
            FastBag.LinkedCacher cacher;
            this.lock_.fastCache_ = null;
            while ((cacher = this.stockHeader_.prev_.remove()) != null) {
                void var2_3;
                bag = var2_3.getFastBag();
                if (bag == null) continue;
                var2_3.clear();
                bag.crack();
            }
            while ((cacher = this.lendHeader_.prev_.remove()) != null) {
                bag = cacher.getFastBag();
                if (bag == null) continue;
                cacher.clear();
                bag.crack();
            }
        }
    }

    public int getLendSize() {
        return this._linkCount(this.lendHeader_);
    }

    public int getSize() {
        return this.total_;
    }

    public int getStockSize() {
        return this._linkCount(this.stockHeader_);
    }

    public boolean putBack(Bag.Cacher cacher) {
        return this.putBack((FastBag.LinkedCacher)cacher);
    }

    public boolean putBack(FastBag.LinkedCacher cacher) {
        Lock lock;
        Lock lock2 = lock = this.lock_;
        synchronized (lock2) {
            if (this.waitCount_ > 0) {
                cacher.moveTo(this.stockHeader_);
                lock.notify();
                --this.waitCount_;
            } else if (lock.fastCache_ == null) {
                lock.fastCache_ = cacher;
            } else {
                cacher.moveTo(this.stockHeader_);
            }
        }
        if (!this.autoDust_) {
            cacher.keep();
        }
        return true;
    }

    public void takeBackAll() {
        Lock lock = this.lock_;
        synchronized (lock) {
            FastBag.LinkedCacher header = this.lendHeader_;
            FastBag.LinkedCacher cacher = header.next_;
            FastBag.LinkedCacher fast = this.lock_.fastCache_;
            while (header != cacher) {
                FastBag bag;
                if (cacher != fast && (bag = cacher.getFastBag()) != null) {
                    if (bag.isActive()) {
                        bag.release();
                    } else {
                        cacher.clear();
                    }
                }
                cacher = cacher.next_;
            }
        }
    }

    public Bag takeOut() {
        Lock lock = this.lock_;
        FastBag ret = null;
        int decCount = 0;
        while (decCount >= 0) {
            FastBag.LinkedCacher cacher;
            Lock lock2 = lock;
            synchronized (lock2) {
                cacher = lock.fastCache_;
                if (cacher != null) {
                    lock.fastCache_ = null;
                    ret = cacher.getFastBag();
                    if (ret == null) {
                        cacher.clear();
                        continue;
                    }
                } else {
                    cacher = this.stockHeader_.prev_;
                    ret = cacher.getFastBag();
                    if (ret != null) {
                        cacher.moveTo(this.lendHeader_);
                    } else {
                        if (cacher.remove() != null) {
                            cacher.clear();
                            continue;
                        }
                        if (!this.useMaximum_ || this.total_ < this.maxSize_) {
                            ret = this._createNewBag();
                            cacher = ret.getLinkedCacher();
                            cacher.moveTo(this.lendHeader_);
                        } else {
                            if (!this.useTimeOut_) {
                                Bag bag = null;
                                return bag;
                            }
                            try {
                                ++this.waitCount_;
                                lock.wait(this.waitTime_);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (this.waitTime_ != 0) {
                                --decCount;
                            }
                            continue;
                        }
                    }
                }
            }
            if (this._activateBag(ret)) {
                if (this.autoDust_) break;
                cacher.unKeep();
                break;
            }
            this._wasteBag(ret);
        }
        return ret;
    }

    public void wasteBag(Bag bag) {
        this._wasteBag((FastBag)bag);
    }

    private boolean _activateBag(FastBag bag) {
        try {
            if (this.useCheckBag_ && !bag.ping()) {
                return false;
            }
            return bag.activate(this.activateKey_);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private FastBag _createNewBag() {
        FastBag ret;
        try {
            ret = ((FastFactory)this.factory_).createNew(this, this.activateKey_);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(this.getClass().toString() + e.toString());
        }
        ++this.total_;
        return ret;
    }

    private int _linkCount(FastBag.LinkedCacher header) {
        int count = 0;
        Lock lock = this.lock_;
        synchronized (lock) {
            FastBag.LinkedCacher cacher = header.next_;
            while (cacher != header) {
                ++count;
                cacher = cacher.next_;
            }
            int n = count;
            return n;
        }
    }

    private void _wasteBag(FastBag bag) {
        System.out.println(this.getClass().toString() + " Only warning:: Bag is wasetd!!");
        try {
            FastBag.LinkedCacher cacher = bag.getLinkedCacher();
            Lock lock = this.lock_;
            synchronized (lock) {
                --this.total_;
                if (this.waitCount_ > 0) {
                    --this.waitCount_;
                    this.lock_.notify();
                }
            }
            bag.crack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class Lock {
        FastBag.LinkedCacher fastCache_ = null;

        Lock() {
        }

        FastBag.LinkedCacher getFastCache() {
            FastBag.LinkedCacher ret = this.fastCache_;
            if (ret == null) {
                return null;
            }
            this.fastCache_ = null;
            return ret;
        }

        boolean setFastCache(FastBag.LinkedCacher cacher) {
            if (this.fastCache_ == null) {
                this.fastCache_ = cacher;
                return true;
            }
            return false;
        }
    }
}

