/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.livewell.baby.pool.Pool;
import jp.livewell.baby.pool.PoolManager;

public class HashManager
implements PoolManager {
    public static final int DEFAULT_BUCKET_SIZE = 11;
    protected Clip[] poolBucket_;
    protected int size_ = 0;

    public HashManager() {
        this(11);
    }

    public HashManager(int bucketSize) {
        this.poolBucket_ = new Clip[bucketSize];
    }

    public void clearAll() {
        Pool[] nPools = this._getPoolArray();
        int i = nPools.length;
        while (i-- > 0) {
            nPools[i].clear();
        }
    }

    public void closeAll() {
        Pool[] nPools = this._getPoolArray();
        int i = nPools.length;
        while (i-- > 0) {
            nPools[i].close();
        }
    }

    public Pool getPool(Object key) {
        Clip[] bucket;
        int hashCode = key.hashCode();
        Clip[] clipArray = bucket = this.poolBucket_;
        synchronized (clipArray) {
            Clip clip = bucket[this._parseIndex(hashCode, bucket.length)];
            while (clip != null) {
                if (clip.hashCode_ == hashCode && clip.key_.equals(key)) {
                    Pool pool = clip.pool_;
                    return pool;
                }
                clip = clip.next_;
            }
        }
        return null;
    }

    public Set keys() {
        Clip[] bucket = this.poolBucket_;
        HashSet<Object> set = new HashSet<Object>();
        Clip[] clipArray = bucket;
        synchronized (clipArray) {
            int i = bucket.length;
            while (i-- > 0) {
                Clip clip = bucket[i];
                while (clip != null) {
                    set.add(clip.key_);
                    clip = clip.next_;
                }
            }
            HashSet<Object> hashSet = set;
            return hashSet;
        }
    }

    public List pools() {
        return Arrays.asList(this._getPoolArray());
    }

    public Pool putPool(Object key, Pool pool) {
        Clip[] bucket;
        int hashCode = key.hashCode();
        Clip[] clipArray = bucket = this.poolBucket_;
        synchronized (clipArray) {
            int index = this._parseIndex(hashCode, bucket.length);
            Clip clip = bucket[index];
            Pool ret = null;
            while (clip != null) {
                if (clip.hashCode_ == hashCode && clip.key_.equals(key)) {
                    ret = clip.pool_;
                    clip.pool_ = pool;
                    ++this.size_;
                    Pool pool2 = ret;
                    return pool2;
                }
                clip = clip.next_;
            }
            ++this.size_;
            bucket[index] = new Clip(key, pool, bucket[index], hashCode);
        }
        return null;
    }

    public Pool removePool(Object key) {
        Clip[] bucket;
        int hashCode = key.hashCode();
        Clip[] clipArray = bucket = this.poolBucket_;
        synchronized (clipArray) {
            int index = this._parseIndex(hashCode, bucket.length);
            Clip clip = bucket[index];
            Object prev = null;
            Pool ret = null;
            while (clip != null) {
                if (clip.hashCode_ == hashCode && clip.key_.equals(key)) {
                    if (prev == null) {
                        bucket[index] = clip.next_;
                    } else {
                        prev.next_ = clip.next_;
                    }
                    ret = clip.pool_;
                    clip.clear();
                    --this.size_;
                    Pool pool = ret;
                    return pool;
                }
                clip = clip.next_;
            }
        }
        return null;
    }

    public int size() {
        return this.size_;
    }

    public void takeBackAll() {
        Pool[] nPools = this._getPoolArray();
        int i = nPools.length;
        while (i-- > 0) {
            nPools[i].takeBackAll();
        }
    }

    private int _parseIndex(int hashCode, int bucketLength) {
        return (hashCode & Integer.MAX_VALUE) % bucketLength;
    }

    private Pool[] _getPoolArray() {
        Clip[] bucket;
        Clip[] clipArray = bucket = this.poolBucket_;
        synchronized (clipArray) {
            Pool[] nPools = new Pool[this.size_];
            int count = 0;
            int i = bucket.length;
            while (i-- > 0) {
                Clip clip = bucket[i];
                while (clip != null) {
                    nPools[count++] = clip.pool_;
                    clip = clip.next_;
                }
            }
            Pool[] poolArray = nPools;
            return poolArray;
        }
    }

    private class Clip {
        Object key_;
        Pool pool_;
        Clip next_;
        int hashCode_;

        Clip(Object key, Pool pool, Clip clip, int hashCode) {
            if (pool == null) {
                throw new NullPointerException(this.getClass().toString() + "can't maping null pool.");
            }
            this.key_ = key;
            this.pool_ = pool;
            this.next_ = clip;
            this.hashCode_ = hashCode;
        }

        void clear() {
            this.key_ = null;
            this.pool_ = null;
            this.next_ = null;
        }

        Object getKey() {
            return this.key_;
        }

        Pool getPool() {
            return this.pool_;
        }

        Clip getNext() {
            return this.next_;
        }

        public int hashCode() {
            return this.hashCode_;
        }
    }
}

