/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool;

import java.util.HashMap;
import java.util.Map;
import jp.livewell.baby.pool.Bag;
import jp.livewell.baby.pool.Factory;
import jp.livewell.baby.pool.InfoBase;

public interface Pool {
    public void clear();

    public void close();

    public int getLendSize();

    public int getMaxSize();

    public int getMinSize();

    public String getName();

    public int getSize();

    public int getStockSize();

    public int getWaitTime();

    public boolean isAutoDust();

    public boolean isUseCheckBag();

    public boolean isUseMaximum();

    public boolean isUseMinimum();

    public boolean isUseTimeOut();

    public boolean putBack(Bag.Cacher var1);

    public void takeBackAll();

    public Bag takeOut();

    public void wasteBag(Bag var1);

    public static class Info
    extends InfoBase {
        public static final String PROP_POOL_NAME = "poolName";
        public static final String PROP_ACTIVATE_KEY = "activateKey";
        public static final String PROP_FACTORY_CLASS = "factoryClass";
        public static final String PROP_FACTORY_INFO = "factoryInfo";
        public static final String PROP_USE_MAX = "useMaximum";
        public static final String PROP_MAXSIZE = "maxSize";
        public static final String PROP_USE_MIN = "useMinimum";
        public static final String PROP_MINSIZE = "minSize";
        public static final String PROP_CHECKBAG = "checkBag";
        public static final String PROP_AUTO_DUST = "useAutoDusting";
        public static final String PROP_USE_TIMEOUT = "useTimeOut";
        public static final String PROP_WAIT_TIME = "waitTime";
        private static final HashMap DEFAULT_INFO;
        protected Key activateKey_;
        boolean autoDust_;
        Class factoryClass_;
        Factory.Info factoryInfo_;
        int maxSize_;
        int minSize_;
        String name_;
        boolean useCheckBag_;
        boolean useMaximum_;
        boolean useMinimum_;
        boolean useTimeOut_;
        int waitTime_;

        public Info() {
        }

        public Info(Info info) {
            this.copy(info);
        }

        public Info(Map props) {
            super(props, DEFAULT_INFO);
        }

        public Info(Map props, Map defaults) {
            super(props, defaults);
        }

        public void clear() {
            try {
                super.clear();
                Object var2_1 = null;
                this.set(DEFAULT_INFO);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.set(DEFAULT_INFO);
                throw throwable;
            }
        }

        protected Object clone() {
            return new Info(this);
        }

        protected void copy(InfoBase info) {
            super.copy(info);
            Info inf = (Info)info;
            this.name_ = inf.name_;
            this.activateKey_ = inf.activateKey_;
            this.factoryClass_ = inf.factoryClass_;
            this.factoryInfo_ = (Factory.Info)inf.factoryInfo_.clone();
            this.useMaximum_ = inf.useMaximum_;
            this.maxSize_ = inf.maxSize_;
            this.useMinimum_ = inf.useMinimum_;
            this.minSize_ = inf.minSize_;
            this.useCheckBag_ = inf.useCheckBag_;
            this.autoDust_ = inf.autoDust_;
            this.useTimeOut_ = inf.useTimeOut_;
            this.waitTime_ = inf.waitTime_;
        }

        protected void setValues(Map props) throws Exception {
            this.name_ = this.getString(props.get(PROP_POOL_NAME));
            this.activateKey_ = (Key)props.get(PROP_ACTIVATE_KEY);
            this.autoDust_ = this.getBoolean(props.get(PROP_AUTO_DUST));
            this.useCheckBag_ = this.getBoolean(props.get(PROP_CHECKBAG));
            this.useMaximum_ = this.getBoolean(props.get(PROP_USE_MAX));
            this.maxSize_ = this.getInt(props.get(PROP_MAXSIZE));
            this.useMinimum_ = this.getBoolean(props.get(PROP_USE_MIN));
            this.minSize_ = this.getInt(props.get(PROP_MINSIZE));
            this.useTimeOut_ = this.getBoolean(props.get(PROP_USE_TIMEOUT));
            this.waitTime_ = this.getInt(props.get(PROP_WAIT_TIME));
            String className = this.getString(props.get(PROP_FACTORY_CLASS));
            this.factoryClass_ = className != null && !className.equals("") ? Class.forName(className) : null;
            this.factoryInfo_ = (Factory.Info)props.get(PROP_FACTORY_INFO);
        }

        public String toString() {
            String ret = super.toString();
            if (this.factoryInfo_ != null) {
                ret = ret + "\n\n" + this.factoryInfo_.toString();
            }
            return ret;
        }

        protected StringBuffer toStringBuffer() {
            StringBuffer buf = super.toStringBuffer();
            buf.append(this.getClass()).append(" :: pool info \n").append(" name = ").append(this.name_).append("\n activateKey = ").append(this.activateKey_).append("\n factoryClass = ").append(this.factoryClass_).append("\n factoryInfo = ").append(this.factoryInfo_).append("\n useMaxixmum = ").append(this.useMaximum_).append("\n maxSize = ").append(this.maxSize_).append("\n useMinimum = ").append(this.useMinimum_).append("\n minSize = ").append(this.minSize_).append("\n useCheckBag = ").append(this.useCheckBag_).append("\n autoDust = ").append(this.autoDust_).append("\n useTimeOut = ").append(this.useTimeOut_).append("\n waitTime = ").append(this.waitTime_).append("\n factory class = ").append(this.factoryClass_);
            return buf;
        }

        public Key getActivateKey() {
            return this.activateKey_;
        }

        public Class getFactoryClass() {
            return this.factoryClass_;
        }

        public Factory.Info getFactoryInfo() {
            return this.factoryInfo_;
        }

        public String getName() {
            return this.name_;
        }

        public int getMaxSize() {
            return this.maxSize_;
        }

        public int getMinSize() {
            return this.minSize_;
        }

        public int getWaitTime() {
            return this.waitTime_;
        }

        public boolean isAutoDust() {
            return this.autoDust_;
        }

        public boolean isUseCheckBag() {
            return this.useCheckBag_;
        }

        public boolean isUseMaximum() {
            return this.useMaximum_;
        }

        public boolean isUseMinimum() {
            return this.useMinimum_;
        }

        public boolean isUseTimeOut() {
            return this.useTimeOut_;
        }

        static {
            HashMap<String, Comparable<Boolean>> map = new HashMap<String, Comparable<Boolean>>();
            map.put(PROP_POOL_NAME, null);
            map.put(PROP_ACTIVATE_KEY, null);
            map.put(PROP_FACTORY_CLASS, null);
            map.put(PROP_FACTORY_INFO, null);
            map.put(PROP_USE_MAX, new Boolean(false));
            map.put(PROP_MAXSIZE, new Integer(0));
            map.put(PROP_USE_MIN, new Boolean(false));
            map.put(PROP_MINSIZE, new Integer(0));
            map.put(PROP_CHECKBAG, new Boolean(true));
            map.put(PROP_AUTO_DUST, new Boolean(true));
            map.put(PROP_USE_TIMEOUT, new Boolean(false));
            map.put(PROP_WAIT_TIME, new Integer(0));
            DEFAULT_INFO = map;
        }
    }

    public static class Key {
    }
}

