/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.livewell.baby.pool.Bag;
import jp.livewell.baby.pool.Factory;
import jp.livewell.baby.pool.Pool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PoolInfoParser {
    public static final String TAG_BABYPOOL = "babyPool";
    public static final String TAG_POOL = "pool";
    public static final String TAG_FACTORY = "factory";
    public static final String TAG_BAG = "bag";
    public static final String TAG_MAXIMUM = "maximum";
    public static final String TAG_MINIMUM = "minimum";
    public static final String TAG_CHECKBAG = "checkBag";
    public static final String TAG_AUTO_DUST = "autoDust";
    public static final String TAG_TIMEOUT = "timeout";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_USE = "use";
    public static final String ATTR_VALUE = "value";
    private DocumentBuilder builder_ = null;

    public PoolInfoParser() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        this.builder_ = dbf.newDocumentBuilder();
    }

    public Pool.Info[] parseInfos(String uri) throws SAXException, IOException {
        return this.parseInfos(new InputSource(uri));
    }

    public Pool.Info[] parseInfos(URL url) throws SAXException, IOException {
        return this.parseInfos(url.openStream());
    }

    public Pool.Info[] parseInfos(InputStream byteStream) throws SAXException, IOException {
        return this.parseInfos(new InputSource(byteStream));
    }

    public Pool.Info[] parseInfos(Reader reader) throws SAXException, IOException {
        return this.parseInfos(new InputSource(reader));
    }

    public Pool.Info[] parseInfos(InputSource source) throws SAXException, IOException {
        Document document = this.builder_.parse(source);
        Element babyElm = this.getBabyPoolElement(document, TAG_BABYPOOL);
        Element[] nPoolElms = this.getPoolElements(babyElm, TAG_POOL);
        int len = nPoolElms.length;
        Pool.Info[] nInfos = new Pool.Info[len];
        int i = len;
        while (i-- > 0) {
            nInfos[i] = this.createPoolInfo(nPoolElms[i]);
        }
        return nInfos;
    }

    protected void addBagProperty(Element elm, Map props) {
    }

    protected void addFactoryProperty(Element elm, Map props) {
    }

    protected void addPoolProperty(Element elm, Map props) {
        if (elm == null) {
            return;
        }
        String tagName = elm.getTagName();
        if (tagName.equals(TAG_MAXIMUM)) {
            props.put("useMaximum", elm.getAttribute(ATTR_USE));
            props.put("maxSize", elm.getAttribute(ATTR_SIZE));
        } else if (tagName.equals(TAG_MINIMUM)) {
            props.put("useMinimum", elm.getAttribute(ATTR_USE));
            props.put("minSize", elm.getAttribute(ATTR_SIZE));
        } else if (tagName.equals(TAG_CHECKBAG)) {
            props.put(TAG_CHECKBAG, elm.getAttribute(ATTR_USE));
        } else if (tagName.equals(TAG_AUTO_DUST)) {
            props.put("useAutoDusting", elm.getAttribute(ATTR_USE));
        } else if (tagName.equals(TAG_TIMEOUT)) {
            props.put("useTimeOut", elm.getAttribute(ATTR_USE));
            props.put("waitTime", elm.getAttribute(ATTR_VALUE));
        } else if (tagName.equals(TAG_FACTORY)) {
            props.put("factoryClass", elm.getAttribute(ATTR_CLASS));
        }
    }

    protected Bag.Info createBagInfo(Element factoryElm) {
        return new Bag.Info(this.parseBagProps(factoryElm, TAG_BAG));
    }

    protected Factory.Info createFactoryInfo(Element poolElm) {
        return new Factory.Info(this.parseFactoryProps(poolElm, TAG_FACTORY));
    }

    protected Pool.Info createPoolInfo(Element poolElm) {
        Map props = this.parsePoolProps(poolElm);
        return new Pool.Info(props);
    }

    protected Element getBabyPoolElement(Document document, String tagName) {
        if (document == null) {
            return null;
        }
        NodeList list = document.getElementsByTagName(tagName);
        if (list.getLength() == 0) {
            return null;
        }
        return (Element)list.item(0);
    }

    protected Text getFirstText(Element elm) {
        if (elm == null) {
            return null;
        }
        NodeList list = elm.getChildNodes();
        int i = list.getLength();
        while (i-- > 0) {
            Node node = list.item(i);
            if (node.getNodeType() != 3) continue;
            return (Text)node;
        }
        return null;
    }

    protected Element[] getPoolElements(Element babyElm, String tagName) {
        if (babyElm == null) {
            return new Element[0];
        }
        NodeList list = babyElm.getElementsByTagName(tagName);
        int len = list.getLength();
        Element[] nRets = new Element[len];
        int i = len;
        while (i-- > 0) {
            nRets[i] = (Element)list.item(i);
        }
        return nRets;
    }

    protected Map parseBagProps(Element factoryElm, String bagTagName) {
        int len;
        NodeList list = factoryElm.getElementsByTagName(bagTagName);
        if (list.getLength() <= 0) {
            return null;
        }
        Element bagElm = (Element)list.item(0);
        Hashtable bagProps = new Hashtable();
        list = bagElm.getChildNodes();
        int i = len = list.getLength();
        while (i-- > 0) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            this.addBagProperty((Element)node, bagProps);
        }
        return bagProps;
    }

    protected Map parseFactoryProps(Element poolElm, String factoryTagName) {
        int len;
        NodeList list = poolElm.getElementsByTagName(factoryTagName);
        if (list.getLength() <= 0) {
            return null;
        }
        Element facElm = (Element)list.item(0);
        Hashtable<String, Bag.Info> facProps = new Hashtable<String, Bag.Info>();
        list = facElm.getChildNodes();
        int i = len = list.getLength();
        while (i-- > 0) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            this.addFactoryProperty((Element)node, facProps);
        }
        facProps.put("bagInfo", this.createBagInfo(facElm));
        return facProps;
    }

    protected Map parsePoolProps(Element poolElm) {
        int len;
        Hashtable<String, Object> poolProps = new Hashtable<String, Object>();
        String poolName = poolElm.getAttribute(ATTR_NAME);
        String poolType = poolElm.getAttribute(ATTR_TYPE);
        poolProps.put("poolName", poolName);
        NodeList list = poolElm.getChildNodes();
        int i = len = list.getLength();
        while (i-- > 0) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            this.addPoolProperty((Element)node, poolProps);
        }
        poolProps.put("factoryInfo", this.createFactoryInfo(poolElm));
        return poolProps;
    }

    public static void main(String[] args) {
        PoolInfoParser me = null;
        try {
            me = new PoolInfoParser();
            Pool.Info[] nInfos = me.parseInfos(args[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

