/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool;

import jp.livewell.baby.pool.ComparisonKey;
import jp.livewell.baby.pool.Factory;
import jp.livewell.baby.pool.Pool;
import jp.livewell.baby.pool.PoolInfo;
import jp.livewell.baby.pool.PoolReference;
import jp.livewell.baby.pool.TimeoutException;
import jp.livewell.baby.pool.Wrapper;

public abstract class AbstractPool
implements Pool {
    private final PoolInfo checker;
    private final String name;
    private int max;
    private int min;
    private int timeout;
    private float grow;
    private float shrink;
    private int minInterval;
    private int idleInterval;
    private boolean isGrowing = false;
    private boolean isShrinking = false;
    private final Factory factory;
    private final PoolReference ref;
    private final ComparisonKey key;

    public AbstractPool(PoolInfo info, Factory factory) {
        this(info, factory, new ComparisonKey());
    }

    public AbstractPool(PoolInfo info, Factory factory, ComparisonKey key) {
        this.name = info.getName();
        this.max = info.getMaxSize();
        this.min = info.getMinSize();
        this.timeout = info.getTimeout();
        this.grow = info.getGrowPoint();
        this.shrink = info.getShrinkPoint();
        this.minInterval = info.getMinCheckInterval();
        this.idleInterval = info.getIdleCheckInterval();
        this.checker = info;
        this.factory = factory;
        this.ref = new PoolReference(this);
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public int getTimeout() {
        return this.timeout;
    }

    protected synchronized void setTimeout(int timeout) throws IllegalArgumentException {
        this.checker.setTimeout(timeout);
        this.timeout = timeout;
    }

    public int getMaxSize() {
        return this.max;
    }

    protected synchronized void setMaxSize(int max) throws IllegalArgumentException {
        this.checker.setMaxSize(max);
        this.max = max;
    }

    public int getMinSize() {
        return this.min;
    }

    protected synchronized void setMinSize(int min) throws IllegalArgumentException {
        this.checker.setMinSize(min);
        this.min = min;
    }

    public float getGrowPoint() {
        return this.grow;
    }

    protected synchronized void setGrowPoint(float grow) throws IllegalArgumentException {
        this.checker.setGrowPoint(grow);
        this.grow = grow;
    }

    public float getShrinkPoint() {
        return this.shrink;
    }

    protected synchronized void setShrinkPoint(float shrink) throws IllegalArgumentException {
        this.checker.setShrinkPoint(shrink);
        this.shrink = shrink;
    }

    public int getMinCheckInterval() {
        return this.minInterval;
    }

    protected synchronized void setMinCheckInterval(int minInterval) throws IllegalArgumentException {
        this.checker.setMinCheckInterval(minInterval);
        this.minInterval = minInterval;
    }

    public int getIdleCheckInterval() {
        return this.idleInterval;
    }

    protected synchronized void setIdleCheckInterval(int idleInterval) throws IllegalArgumentException {
        this.checker.setIdleCheckInterval(idleInterval);
        this.idleInterval = idleInterval;
    }

    public Factory getFactory() {
        return this.factory;
    }

    public PoolReference getPoolReference() {
        return this.ref;
    }

    protected ComparisonKey getComparisonKey() {
        return this.key;
    }

    public Wrapper takeout() throws TimeoutException {
        return this.takeout(this.timeout);
    }

    public void restore(Wrapper wrp) throws IllegalArgumentException {
        try {
            if (wrp.passivate(this.key)) {
                this.addPooledInstance(wrp);
            }
        }
        catch (IllegalStateException e) {
            this.dispose(wrp);
        }
    }

    protected abstract void addPooledInstance(Wrapper var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean grow() {
        boolean isSuccess = false;
        try {
            block11: {
                try {
                    Wrapper wrp;
                    block13: {
                        block14: {
                            block12: {
                                AbstractPool abstractPool = this;
                                // MONITORENTER : abstractPool
                                if (this.isGrowing || this.getTotalSize() >= this.max) break block12;
                                this.isGrowing = true;
                                // MONITOREXIT : abstractPool
                                wrp = this.factory.create();
                                wrp.init(this.ref, this.key);
                                if (!this.addNewInstance(wrp)) break block13;
                                break block14;
                            }
                            boolean bl = false;
                            // MONITOREXIT : abstractPool
                            Object var6_6 = null;
                            AbstractPool abstractPool = this;
                            // MONITORENTER : abstractPool
                            this.isGrowing = false;
                            // MONITOREXIT : abstractPool
                            return bl;
                        }
                        isSuccess = true;
                        break block11;
                    }
                    wrp.destroy(this.key);
                }
                catch (Exception e) {
                    Object var6_8 = null;
                    AbstractPool abstractPool = this;
                    // MONITORENTER : abstractPool
                    this.isGrowing = false;
                    // MONITOREXIT : abstractPool
                    return isSuccess;
                }
            }
            Object var6_7 = null;
            AbstractPool abstractPool = this;
            // MONITORENTER : abstractPool
            this.isGrowing = false;
            // MONITOREXIT : abstractPool
            return isSuccess;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            AbstractPool abstractPool = this;
            // MONITORENTER : abstractPool
            this.isGrowing = false;
            // MONITOREXIT : abstractPool
            throw throwable;
        }
    }

    protected abstract boolean addNewInstance(Wrapper var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean shrink() {
        boolean isSuccess;
        block14: {
            AbstractPool abstractPool;
            boolean bl;
            block15: {
                isSuccess = false;
                try {
                    try {
                        Wrapper wrp;
                        AbstractPool abstractPool2 = this;
                        synchronized (abstractPool2) {
                            if (!this.isShrinking && this.getTotalSize() > this.min) {
                                this.isShrinking = true;
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 13] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                                wrp = this.takeout(-1);
                                if (wrp == null) break block14;
                            } else {
                                bl = false;
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 12] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                                Object var6_6 = null;
                                abstractPool = this;
                                break block15;
                            }
                        }
                        this.dispose(wrp);
                        isSuccess = true;
                        break block14;
                    }
                    catch (Exception e) {
                        Object var6_8 = null;
                        AbstractPool abstractPool3 = this;
                        synchronized (abstractPool3) {
                            this.isShrinking = false;
                            return isSuccess;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    AbstractPool abstractPool4 = this;
                    synchronized (abstractPool4) {
                        this.isShrinking = false;
                        throw throwable;
                    }
                }
            }
            synchronized (abstractPool) {
                this.isShrinking = false;
                return bl;
            }
        }
        Object var6_7 = null;
        AbstractPool abstractPool = this;
        synchronized (abstractPool) {
            this.isShrinking = false;
            return isSuccess;
        }
    }

    public abstract void dispose(Wrapper var1) throws IllegalArgumentException;

    public abstract Wrapper takeout(int var1) throws TimeoutException;

    public abstract int getWaitSize();

    public abstract int getTotalSize();

    public abstract int getStoredSize();

    public abstract int getRemovedSize();
}

