/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool;

import jp.livewell.baby.pool.ComparisonKey;
import jp.livewell.baby.pool.NullPool;
import jp.livewell.baby.pool.PoolReference;
import jp.livewell.baby.pool.Wrapper;

public abstract class AbstractWrapper
implements Wrapper {
    private boolean isInit = false;
    private boolean isActive = false;
    private boolean isDestroy = false;
    private PoolReference poolRef;
    private ComparisonKey key;

    public AbstractWrapper() {
        this.setNullReference();
    }

    private synchronized void setNullReference() {
        this.poolRef = NullPool.getInstance().getPoolReference();
        this.key = NullPool.getDefaultComparisonKey();
    }

    public synchronized void init(PoolReference poolRef, ComparisonKey key) throws IllegalStateException {
        if (!this.isInit) {
            if (poolRef != null) {
                this.poolRef = poolRef;
                this.key = key;
            } else {
                this.setNullReference();
            }
        } else {
            throw new IllegalStateException("already init this Wrapper!!");
        }
        this.isInit = true;
    }

    public synchronized boolean isWorkable() {
        return this.isActive && !this.isDestroy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean activate(ComparisonKey key) throws IllegalStateException, IllegalArgumentException {
        boolean isSuccess = false;
        if (this.isActive) return isSuccess;
        if (this.key != key) throw new IllegalArgumentException("ComparisonKey not matched!");
        if (!this.ping()) throw new IllegalStateException("Wrapped Object is invalid state!");
        this.isActive = true;
        return true;
    }

    protected abstract boolean ping();

    public synchronized boolean passivate(ComparisonKey key) throws IllegalStateException, IllegalArgumentException {
        boolean isSuccess = false;
        if (this.isActive) {
            if (this.key == key) {
                this.isActive = false;
                isSuccess = true;
            } else {
                throw new IllegalArgumentException("ComparisonKey not matched!");
            }
        }
        return isSuccess;
    }

    public void release() {
        this.poolRef.get().restore(this);
    }

    public synchronized void destroy(ComparisonKey key) throws IllegalArgumentException {
        if (this.key == key) {
            try {
                block6: {
                    try {
                        if (!this.isActive) break block6;
                        this.passivate(key);
                    }
                    catch (Exception e) {
                        Object var4_3 = null;
                        this.isDestroy = true;
                        this.setNullReference();
                    }
                }
                Object var4_2 = null;
                this.isDestroy = true;
                this.setNullReference();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.isDestroy = true;
                this.setNullReference();
                throw throwable;
            }
        } else {
            throw new IllegalArgumentException("ComparisonKey not matched!");
        }
    }

    protected void finalize() throws Throwable {
        try {
            AbstractWrapper abstractWrapper = this;
            synchronized (abstractWrapper) {
                this.poolRef.get().dispose(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected boolean isInitialized() {
        return this.isInit;
    }

    protected boolean isActivated() {
        return this.isActive;
    }

    protected boolean isDestroyed() {
        return this.isDestroy;
    }

    protected PoolReference getPoolReference() {
        return this.poolRef;
    }

    protected ComparisonKey getComparisonKey() {
        return this.key;
    }
}

