/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool;

import java.util.Collection;
import java.util.Iterator;
import jp.livewell.baby.pool.AbstractPool;
import jp.livewell.baby.pool.ComparisonKey;
import jp.livewell.baby.pool.Factory;
import jp.livewell.baby.pool.Pool;
import jp.livewell.baby.pool.PoolInfo;
import jp.livewell.baby.pool.Queue;
import jp.livewell.baby.pool.TimeoutException;
import jp.livewell.baby.pool.Wrapper;

public class DefaultPool
extends AbstractPool {
    private int total = 0;
    private int waits = 0;
    private final Queue queue = new Queue(this.getMaxSize());
    private final Blancer blancer = new Blancer(this);
    private Wrapper cache = null;

    public DefaultPool(PoolInfo info, Factory factory) {
        super(info, factory);
        this.blancer.start();
    }

    protected synchronized void setMaxSize(int max) throws IllegalArgumentException {
        super.setMaxSize(max);
        ComparisonKey key = this.getComparisonKey();
        Collection overs = this.queue.addjustMax(max);
        Iterator itr = overs.iterator();
        while (itr.hasNext()) {
            Wrapper wrp = (Wrapper)itr.next();
            wrp.destroy(key);
        }
    }

    protected synchronized void setMinCheckInterval(int minInterval) throws IllegalArgumentException {
        super.setMinCheckInterval(minInterval);
        this.blancer.timingChanged();
    }

    protected synchronized void setIdleCheckInterval(int idleInterval) throws IllegalArgumentException {
        super.setIdleCheckInterval(idleInterval);
        this.blancer.timingChanged();
    }

    public synchronized int getRemovedSize() {
        return this.total - this.getStoredSize();
    }

    public synchronized int getStoredSize() {
        return this.queue.size() + (this.cache != null ? 1 : 0);
    }

    public synchronized int getTotalSize() {
        return this.total;
    }

    public synchronized int getWaitSize() {
        return this.waits;
    }

    public Wrapper takeout(int maxTime) throws TimeoutException {
        while (true) {
            Wrapper wrp = null;
            boolean more = true;
            DefaultPool defaultPool = this;
            synchronized (defaultPool) {
                block10: {
                    block11: {
                        while (true) {
                            if ((wrp = this.cache) != null) {
                                this.cache = null;
                                break block10;
                            }
                            wrp = this.queue.remove();
                            if (wrp != null) break block10;
                            if (!more) break block11;
                            if (maxTime < 0) break;
                            ++this.waits;
                            try {
                                this.wait(maxTime);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            --this.waits;
                            more = maxTime == 0;
                        }
                        Wrapper e = null;
                        return e;
                    }
                    throw new TimeoutException();
                }
            }
            try {
                wrp.activate(this.getComparisonKey());
                return wrp;
            }
            catch (IllegalStateException e) {
                this.dispose(wrp);
                continue;
            }
            break;
        }
    }

    protected synchronized void addPooledInstance(Wrapper wrp) {
        if (this.cache == null) {
            this.cache = wrp;
        } else if (!this.queue.add(wrp)) {
            this.dispose(wrp);
            return;
        }
        if (this.waits > 0) {
            this.notify();
        }
    }

    protected synchronized boolean addNewInstance(Wrapper wrp) {
        boolean isSuccess = false;
        if (this.cache == null) {
            this.cache = wrp;
            isSuccess = true;
        } else {
            isSuccess = this.queue.add(wrp);
        }
        if (isSuccess) {
            ++this.total;
            if (this.waits > 0) {
                this.notify();
            }
        }
        return isSuccess;
    }

    public void dispose(Wrapper wrp) throws IllegalArgumentException {
        try {
            wrp.destroy(this.getComparisonKey());
            DefaultPool defaultPool = this;
            synchronized (defaultPool) {
                --this.total;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    private final class Blancer
    extends Thread {
        private final Pool pool;
        private boolean changed = false;
        private float center;
        private int adjust;

        Blancer(Pool pool) {
            super(pool.getName() + "'s blancer");
            this.pool = pool;
            this.recalcTiming();
        }

        public void start() {
            this.setDaemon(true);
            super.start();
        }

        public void run() {
            float rateAvg = 0.0f;
            while (true) {
                int blance = 0;
                int max = 0;
                int min = 0;
                int removed = 0;
                int waits = 0;
                int total = 0;
                float rate = 0.0f;
                boolean isMore = false;
                Pool pool = this.pool;
                synchronized (pool) {
                    max = this.pool.getMaxSize();
                    min = this.pool.getMinSize();
                    removed = this.pool.getRemovedSize();
                    waits = this.pool.getWaitSize();
                    total = this.pool.getTotalSize();
                    rate = total > 0 ? (float)(removed + waits) / (float)total : (float)(removed + waits);
                    rateAvg = (rateAvg * 7.0f + rate) / 8.0f;
                    if (min <= total && total <= max) {
                        if (total != max && rateAvg >= this.pool.getGrowPoint()) {
                            ++blance;
                        } else if (total != min && rateAvg <= this.pool.getShrinkPoint()) {
                            --blance;
                        }
                    } else {
                        ++blance;
                    }
                }
                if (blance != 0) {
                    if (blance > 0) {
                        isMore = this.pool.grow();
                    } else if (blance < 0) {
                        isMore = this.pool.shrink();
                    }
                    rateAvg = rateAvg * (float)total / (float)this.pool.getTotalSize();
                }
                if (isMore) continue;
                Blancer blancer = this;
                synchronized (blancer) {
                    if (this.changed) {
                        this.recalcTiming();
                    }
                    float x = rateAvg - this.center;
                    int minIv = DefaultPool.this.getMinCheckInterval();
                    int wait = (int)((float)this.adjust * (x * x)) + minIv;
                    try {
                        this.wait(wait);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        }

        synchronized void timingChanged() {
            this.changed = true;
        }

        private synchronized void recalcTiming() {
            this.center = (DefaultPool.this.getGrowPoint() + DefaultPool.this.getShrinkPoint()) / 2.0f;
            this.adjust = (int)((float)(DefaultPool.this.getIdleCheckInterval() - DefaultPool.this.getMinCheckInterval()) / (this.center * this.center));
            this.changed = false;
        }
    }
}

