/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool;

import jp.livewell.baby.pool.AbstractPool;
import jp.livewell.baby.pool.ComparisonKey;
import jp.livewell.baby.pool.NullFactory;
import jp.livewell.baby.pool.PoolInfo;
import jp.livewell.baby.pool.Wrapper;

final class NullPool
extends AbstractPool {
    private static NullPool single = null;

    static synchronized NullPool getInstance() {
        if (single == null) {
            PoolInfo info = new PoolInfo();
            info.setName("NullPool");
            single = new NullPool(info, new NullFactory());
        }
        return single;
    }

    private NullPool(PoolInfo info, NullFactory factory) {
        super(info, factory);
    }

    public int getRemovedSize() {
        return 0;
    }

    public int getStoredSize() {
        return 0;
    }

    public int getTotalSize() {
        return 0;
    }

    public int getWaitSize() {
        return 0;
    }

    public Wrapper takeout(int waitTime) {
        return null;
    }

    public void restore(Wrapper wrp) throws IllegalArgumentException {
        try {
            super.restore(wrp);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public boolean grow() {
        return false;
    }

    public boolean shrink() {
        return false;
    }

    public void dispose(Wrapper wrp) throws IllegalArgumentException {
        try {
            wrp.destroy(this.getComparisonKey());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static ComparisonKey getDefaultComparisonKey() {
        return NullPool.getInstance().getComparisonKey();
    }

    protected synchronized void addPooledInstance(Wrapper wrp) {
        this.dispose(wrp);
    }

    protected synchronized boolean addNewInstance(Wrapper wrp) {
        return false;
    }
}

