/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool;

public class PoolInfo
implements Cloneable {
    private String name;
    private int max;
    private int min;
    private int timeout;
    private float grow;
    private float shrink;
    private int minInterval;
    private int idleInterval;

    public PoolInfo() {
        this.init();
    }

    protected PoolInfo(PoolInfo master) {
        this.name = master.getName();
        this.max = master.getMaxSize();
        this.min = master.getMinSize();
        this.timeout = master.getTimeout();
        this.grow = master.getGrowPoint();
        this.shrink = master.getShrinkPoint();
        this.minInterval = master.getMinCheckInterval();
        this.idleInterval = master.getIdleCheckInterval();
    }

    private void init() {
        this.name = "defaultPool";
        this.max = 10;
        this.min = 5;
        this.timeout = 0;
        this.grow = 0.8f;
        this.shrink = 0.2f;
        this.minInterval = 100;
        this.idleInterval = 1000;
    }

    public Object clone() {
        return new PoolInfo(this);
    }

    public boolean equals(Object o) {
        boolean isSame = false;
        if (o instanceof PoolInfo) {
            PoolInfo other = (PoolInfo)o;
            isSame = this.name.equals(other.getName()) && this.max == other.getMaxSize() && this.min == other.getMinSize() && this.timeout == other.getTimeout() && this.grow == other.getGrowPoint() && this.shrink == other.getShrinkPoint() && this.minInterval == other.getMinCheckInterval() && this.idleInterval == other.getIdleCheckInterval();
        }
        return isSame;
    }

    public String toString() {
        return this.getClass().getName() + "\n" + "name = " + this.name + "\n" + "maxSize = " + this.max + "\n" + "minSize = " + this.min + "\n" + "timeout = " + this.timeout + "\n" + "growPoint = " + this.grow + "\n" + "shrinkPoint = " + this.shrink + "\n" + "minCheckInterval = " + this.minInterval + "\n" + "idleCheckInterval = " + this.idleInterval + "\n\n";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws IllegalArgumentException {
        if (name != null) {
            boolean found = false;
            char[] illegals = new char[]{'!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '=', '+', '\\', '|', '`', '~', '[', '{', ']', '}', ';', ':', '\'', '\"', ',', '<', '.', '>', '/', '?'};
            int i = 0;
            while (i < illegals.length) {
                if (name.indexOf(illegals[i]) > -1) {
                    throw new IllegalArgumentException("illegal string found in name = " + name);
                }
                ++i;
            }
        } else {
            throw new NullPointerException("can't set null name");
        }
        this.name = name;
    }

    public int getMaxSize() {
        return this.max;
    }

    public void setMaxSize(int max) throws IllegalArgumentException {
        if (max <= 0) {
            throw new IllegalArgumentException("can't set max size under 0");
        }
        this.max = max;
    }

    public int getMinSize() {
        return this.min;
    }

    public void setMinSize(int min) throws IllegalArgumentException {
        if (min < 0) {
            throw new IllegalArgumentException("can't set max size less than 0");
        }
        this.min = min;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public float getGrowPoint() {
        return this.grow;
    }

    public void setGrowPoint(float grow) throws IllegalArgumentException {
        if (!(0.0f < grow) || !(grow < 1.0f)) {
            throw new IllegalArgumentException("can't set grow point under 0 or over 1.");
        }
        this.grow = grow;
    }

    public float getShrinkPoint() {
        return this.shrink;
    }

    public void setShrinkPoint(float shrink) throws IllegalArgumentException {
        if (!(0.0f < shrink) || !(shrink < 1.0f)) {
            throw new IllegalArgumentException("can't set shrink point under 0 or over 1.");
        }
        this.shrink = shrink;
    }

    public int getMinCheckInterval() {
        return this.minInterval;
    }

    public void setMinCheckInterval(int minInterval) throws IllegalArgumentException {
        if (0 >= minInterval) {
            throw new IllegalArgumentException("can't set minimum check interval to under 0.");
        }
        this.minInterval = minInterval;
    }

    public int getIdleCheckInterval() {
        return this.idleInterval;
    }

    public void setIdleCheckInterval(int idleInterval) throws IllegalArgumentException {
        if (0 >= idleInterval) {
            throw new IllegalArgumentException("can't set idle check interval to under 0.");
        }
        this.idleInterval = idleInterval;
    }
}

