/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool;

import java.util.ArrayList;
import java.util.Collection;
import jp.livewell.baby.pool.Wrapper;

class Queue {
    private Wrapper[] nWraps;
    private int max;
    private int head;
    private int tail;
    private boolean full;

    Queue(int max) {
        this.nWraps = new Wrapper[max];
        this.max = max;
        this.head = 0;
        this.tail = 0;
        this.full = false;
    }

    int max() {
        return this.max;
    }

    int size() {
        int ret;
        if (!this.full) {
            ret = this.head - this.tail;
            if (ret < 0) {
                ret += this.max;
            }
        } else {
            ret = this.max;
        }
        return ret;
    }

    boolean isEmpty() {
        return this.head == this.tail && !this.full;
    }

    boolean isFull() {
        return this.full;
    }

    boolean add(Wrapper wrp) throws NullPointerException {
        if (!this.full) {
            if (wrp != null) {
                ++this.head;
                this.head %= this.max;
                this.nWraps[this.head] = wrp;
                this.full = this.head == this.tail;
                return true;
            }
            throw new NullPointerException("can't add null");
        }
        return false;
    }

    Wrapper remove() {
        if (this.head != this.tail || this.full) {
            ++this.tail;
            this.tail %= this.max;
            Wrapper wrp = this.nWraps[this.tail];
            this.nWraps[this.tail] = null;
            this.full = false;
            return wrp;
        }
        return null;
    }

    Collection addjustMax(int max) throws IllegalArgumentException {
        if (max > 0) {
            Wrapper[] oldArr = this.nWraps;
            this.nWraps = new Wrapper[max];
            this.max = max;
            this.head = 0;
            this.tail = 0;
            this.full = false;
            ArrayList<Wrapper> overs = new ArrayList<Wrapper>();
            int i = 0;
            while (i < oldArr.length) {
                Wrapper wrp = oldArr[i];
                if (wrp != null) {
                    if (!this.full) {
                        this.add(wrp);
                    } else {
                        overs.add(wrp);
                    }
                }
                ++i;
            }
            return overs;
        }
        throw new IllegalArgumentException("can't set under 0 value.");
    }
}

