/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool.jdbc;

import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import jp.livewell.baby.io.NullWriter;
import jp.livewell.baby.pool.Factory;
import jp.livewell.baby.pool.Wrapper;
import jp.livewell.baby.pool.jdbc.ConnectionPoolInfo;
import jp.livewell.baby.pool.jdbc.ConnectionWrapper;
import jp.livewell.baby.pool.jdbc.ResourceManager;

public class ConnectionFactory
implements Factory {
    private Driver driver;
    private String url;
    private Properties prop;
    private String command;
    private long interval;
    private Connection closedConn = null;
    private ConnectionWrapper.DefaultValues defaults = null;
    private boolean isInit = false;
    private PrintWriter logger = new PrintWriter(System.err, true);

    protected ConnectionFactory() {
        this.driver = null;
        this.url = "";
        this.prop = new Properties();
        this.command = "";
        this.interval = 0L;
    }

    public ConnectionFactory(ConnectionPoolInfo info) throws SQLException {
        this.init(info);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void init(ConnectionPoolInfo info) throws SQLException, IllegalStateException {
        if (!this.isInit) {
            if (!this.connectTest(info)) throw new SQLException("factory initializing failed!\n dump ConnectionPoolInfo.\n" + info);
            try {
                this.driver = this.loadDriver(info.getDriverName());
                this.url = info.getUrl();
                this.prop = info.toProperties();
                this.command = info.getPingCommand();
                this.interval = info.getPingInterval();
                this.isInit = true;
                Connection conn = this.getConnection();
                this.defaults = new ConnectionWrapper.DefaultValues(conn);
                conn.close();
                this.closedConn = conn;
                return;
            }
            catch (Exception e) {
                this.logger.println("[ConnectionFactory: error] test is done. but catch exception. why??? stack trace...");
                e.printStackTrace(this.logger);
                throw new SQLException("factory initializing failed!\n error is " + e + "\n" + " dump ConnectionPoolInfo.\n" + info + ".\n");
            }
        } else {
            this.logger.println("[ConnectionFactory: error] already initialized!");
            throw new IllegalStateException("already initialized. can't call init already init.");
        }
    }

    public PrintWriter getLogWriter() {
        return this.logger;
    }

    public void setLogWriter(PrintWriter logger) {
        this.logger = logger != null ? logger : new PrintWriter((Writer)new NullWriter(), true);
    }

    public boolean isInit() {
        return this.isInit;
    }

    Driver getDriver() throws IllegalStateException {
        if (this.isInit) {
            return this.driver;
        }
        throw new IllegalStateException("this pool is not initialized!");
    }

    String getUrl() throws IllegalStateException {
        if (this.isInit) {
            return this.url;
        }
        throw new IllegalStateException("this pool is not initialized!");
    }

    Properties getInfo() throws IllegalStateException {
        if (this.isInit) {
            return (Properties)((Hashtable)this.prop).clone();
        }
        throw new IllegalStateException("this pool is not initialized!");
    }

    boolean hasSameData(String url, Properties info) throws IllegalStateException {
        if (this.isInit) {
            return this.url.equals(url) && ((Hashtable)this.prop).equals(info);
        }
        throw new IllegalStateException("this pool is not initialized!");
    }

    public Wrapper create() throws Exception {
        Connection conn = this.getConnection();
        return new ConnectionWrapper(conn, this.closedConn, this.command, this.interval, this.defaults);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean connectTest(ConnectionPoolInfo info) {
        try {
            boolean isSuccess;
            Driver drv = this.loadDriver(info.getDriverName());
            Connection conn = null;
            try {
                conn = drv.connect(info.getUrl(), info.toProperties());
                Statement stmt = conn.createStatement();
                stmt.executeQuery(info.getPingCommand());
                isSuccess = true;
                Object var7_7 = null;
                if (conn == null) return isSuccess;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            conn.close();
            return isSuccess;
        }
        catch (Exception e) {
            this.logger.println("[ConnectionFactory: error] connect test failed! stack trace...");
            e.printStackTrace(this.logger);
            this.logger.println("ConnectionPoolInfo dump here");
            this.logger.println(info);
            return false;
        }
    }

    public Connection getConnection() throws SQLException, IllegalStateException {
        Connection conn = null;
        if (this.isInit) {
            conn = this.driver.connect(this.url, this.prop);
            if (conn != null) {
                return conn;
            }
            throw new SQLException("get JDBC Connection failed!");
        }
        throw new IllegalStateException("this pool is not initialized!");
    }

    protected Driver loadDriver(String driverName) throws ClassNotFoundException, RuntimeException {
        Driver drv = null;
        ResourceManager manager = ResourceManager.getInstance();
        drv = manager.findDriverByName(driverName);
        if (drv == null) {
            Class.forName(driverName);
            Enumeration<Driver> enumeration = DriverManager.getDrivers();
            while (enumeration.hasMoreElements()) {
                Driver d = enumeration.nextElement();
                if (!d.getClass().getName().equals(driverName)) continue;
                drv = d;
                this.logger.println("[ConnectionFactory: status] load JDBC Driver '" + driverName + "' success.");
                break;
            }
        }
        if (drv == null) {
            try {
                drv = (Driver)Class.forName(driverName).newInstance();
            }
            catch (Exception e) {
                this.logger.println("[ConnectionFactory: error] load JDBC Driver '" + driverName + "' failed!!");
                throw new RuntimeException("cannot load jdbc driver for babyPool.\ndriver name = " + driverName + "\n");
            }
        }
        return drv;
    }
}

