/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import jp.livewell.baby.pool.DefaultPool;
import jp.livewell.baby.pool.TimeoutException;
import jp.livewell.baby.pool.jdbc.ConnectionFactory;
import jp.livewell.baby.pool.jdbc.ConnectionPoolInfo;

public class ConnectionPool
extends DefaultPool
implements DataSource,
Referenceable {
    public static final int CONNECT_IMPOSSIBLE = 0;
    public static final int CONNECT_ACCEPT = 1;
    public static final int CONNECT_POOLING = 2;
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private static final int NON_BLOCK = -1;
    static /* synthetic */ Class class$javax$sql$DataSource;
    static /* synthetic */ Class class$jp$livewell$baby$pool$jdbc$DataSourceFactory;

    public ConnectionPool(ConnectionPoolInfo info) throws SQLException {
        super(info, new ConnectionFactory(info));
    }

    int checkAvailable(String url) throws SQLException {
        return this.checkAvailable(url, EMPTY_PROPERTIES);
    }

    int checkAvailable(String url, Properties info) throws SQLException {
        int available = 0;
        ConnectionFactory fac = (ConnectionFactory)this.getFactory();
        if (fac.hasSameData(url, info)) {
            available = 2;
        } else if (fac.getUrl().equals(url)) {
            available = 1;
        } else if (fac.getDriver().acceptsURL(url)) {
            available = 1;
        }
        return available;
    }

    public Connection getConnection(String url, Properties prop) throws SQLException {
        Connection conn;
        ConnectionFactory fac = (ConnectionFactory)this.getFactory();
        if (fac.hasSameData(url, prop)) {
            while ((conn = (Connection)((Object)this.takeout(-1))) == null) {
                if (this.grow()) continue;
                try {
                    conn = (Connection)((Object)this.takeout());
                    break;
                }
                catch (TimeoutException e) {
                    throw new SQLException(e.toString());
                }
            }
        } else {
            try {
                conn = fac.getDriver().connect(url, prop);
            }
            catch (IllegalStateException e) {
                throw new SQLException(e.toString());
            }
        }
        return conn;
    }

    public final Connection getConnection() throws SQLException {
        try {
            return (Connection)((Object)this.takeout());
        }
        catch (TimeoutException e) {
            throw new SQLException("pool timeout.");
        }
    }

    public Connection getConnection(String user, String password) throws SQLException {
        ConnectionFactory fac = (ConnectionFactory)this.getFactory();
        Properties info = fac.getInfo();
        info.setProperty("user", user);
        info.setProperty("password", password);
        return this.getConnection(fac.getUrl(), info);
    }

    public int getLoginTimeout() throws SQLException {
        return this.getTimeout();
    }

    public void setLoginTimeout(int timeout) throws SQLException {
        try {
            this.setTimeout(timeout);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e.toString());
        }
    }

    public PrintWriter getLogWriter() throws SQLException {
        return ((ConnectionFactory)this.getFactory()).getLogWriter();
    }

    public void setLogWriter(PrintWriter pw) throws SQLException {
        ((ConnectionFactory)this.getFactory()).setLogWriter(pw);
    }

    public Reference getReference() {
        StringRefAddr refAddr = new StringRefAddr((class$javax$sql$DataSource == null ? (class$javax$sql$DataSource = ConnectionPool.class$("javax.sql.DataSource")) : class$javax$sql$DataSource).getName(), this.getName());
        return new Reference(this.getClass().getName(), refAddr, (class$jp$livewell$baby$pool$jdbc$DataSourceFactory == null ? (class$jp$livewell$baby$pool$jdbc$DataSourceFactory = ConnectionPool.class$("jp.livewell.baby.pool.jdbc.DataSourceFactory")) : class$jp$livewell$baby$pool$jdbc$DataSourceFactory).getName(), null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

