/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool.jdbc;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import jp.livewell.baby.pool.PoolInfo;

public class ConnectionPoolInfo
extends PoolInfo {
    public static final String KEY_USER = "user";
    public static final String KEY_PASSWORD = "password";
    private String driver;
    private String url;
    private final Properties connInfo = new Properties();
    private String command;
    private long interval;

    public ConnectionPoolInfo() {
        this.init();
    }

    protected ConnectionPoolInfo(ConnectionPoolInfo master) {
        super(master);
        this.driver = master.getDriverName();
        this.url = master.getUrl();
        this.command = master.getPingCommand();
        this.interval = master.getPingInterval();
        ((Hashtable)this.connInfo).putAll(master.toProperties());
    }

    private void init() {
        this.driver = "";
        this.url = "";
        this.command = "select 1";
        this.interval = 1000L;
        this.connInfo.setProperty(KEY_USER, "");
        this.connInfo.setProperty(KEY_PASSWORD, "");
    }

    public Object clone() {
        return new ConnectionPoolInfo(this);
    }

    public boolean equals(Object o) {
        boolean isSame = false;
        if (super.equals(o) && o instanceof ConnectionPoolInfo) {
            ConnectionPoolInfo other = (ConnectionPoolInfo)o;
            isSame = this.driver.equals(other.getDriverName()) && this.url.equals(other.getUrl()) && ((Hashtable)this.connInfo).equals(other.toProperties()) && this.command.equals(other.getPingCommand()) && this.interval == other.getPingInterval();
        }
        return isSame;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString()).append("driverName = ").append(this.driver).append("\n").append("url = ").append(this.url).append("\n");
        Enumeration<?> names = this.connInfo.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            buf.append(name).append(" = ").append(this.connInfo.getProperty(name)).append("\n");
        }
        buf.append("pingCommand = " + this.command).append("\n").append("pingInterval = " + this.interval).append("\n").append("\n");
        return buf.toString();
    }

    public String getDriverName() {
        return this.driver;
    }

    public void setDriverName(String className) throws IllegalArgumentException {
        try {
            Class<?> cls = Class.forName(className);
            this.driver = className;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) throws NullPointerException {
        if (url == null) {
            throw new NullPointerException("can't set null database URL!!");
        }
        this.url = url;
    }

    public String getUser() {
        return this.connInfo.getProperty(KEY_USER);
    }

    public void setUser(String userName) throws NullPointerException {
        if (userName == null) {
            throw new NullPointerException("can't set null database user name!!");
        }
        this.connInfo.setProperty(KEY_USER, userName);
    }

    public String getPassword() {
        return this.connInfo.getProperty(KEY_PASSWORD);
    }

    public void setPassword(String password) throws NullPointerException {
        if (password == null) {
            throw new NullPointerException("can't set null database user's password.");
        }
        this.connInfo.setProperty(KEY_PASSWORD, password);
    }

    public String getExtention(String key) throws NullPointerException {
        if (key != null) {
            return this.connInfo.getProperty(key);
        }
        throw new NullPointerException("can't use null key.");
    }

    public void setExtention(String key, String val) throws NullPointerException {
        if (key == null || val == null) {
            throw new NullPointerException("key or val is null.");
        }
        this.connInfo.setProperty(key, val);
    }

    public String getPingCommand() {
        return this.command;
    }

    public void setPingCommand(String command) throws NullPointerException {
        if (command == null) {
            throw new NullPointerException("can't set null ping command!!");
        }
        this.command = command;
    }

    public long getPingInterval() {
        return this.interval;
    }

    public void setPingInterval(long interval) throws IllegalArgumentException {
        if (interval < 0L) {
            throw new IllegalArgumentException("can't set minous value to pingInterval!!");
        }
        this.interval = interval;
    }

    public Properties toProperties() {
        return (Properties)((Hashtable)this.connInfo).clone();
    }
}

