/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool.jdbc;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.livewell.baby.pool.jdbc.ConnectionPoolInfo;

abstract class ConnectionPoolInfoLoader {
    private static final String RESOURCE_PATH = "jp.livewell.baby.pool.jdbc";
    private static final String RESOURCE_NAME = "babyPool";
    private static final String[] SUB_CLASS_NAMES = new String[]{"jp.livewell.baby.pool.jdbc.PropertiesLoader", "jp.livewell.baby.pool.jdbc.XmlLoader"};
    private boolean isInit = false;
    private String resourcePath = "";
    private String resourceName = "";
    static /* synthetic */ Class class$java$lang$String;

    static ConnectionPoolInfoLoader createInstance() throws RuntimeException {
        boolean isFound = false;
        ConnectionPoolInfoLoader loader = null;
        int i = 0;
        while (i < SUB_CLASS_NAMES.length) {
            block8: {
                Class<?> cls = null;
                String subclassName = SUB_CLASS_NAMES[i];
                try {
                    cls = Class.forName(subclassName);
                }
                catch (ClassNotFoundException e) {
                    break block8;
                }
                try {
                    loader = (ConnectionPoolInfoLoader)cls.newInstance();
                }
                catch (InstantiationException e) {
                    break block8;
                }
                catch (IllegalAccessException e) {
                    break block8;
                }
                loader.init(RESOURCE_PATH, RESOURCE_NAME);
                if (loader.isFoundResource()) {
                    isFound = true;
                    break;
                }
            }
            ++i;
        }
        if (isFound) {
            return loader;
        }
        throw new RuntimeException("can't find babyPool resource. please check classpath.");
    }

    protected ConnectionPoolInfoLoader() {
    }

    void init(String resPath, String resName) {
        this.resourcePath = resPath;
        this.resourceName = resName;
        this.isInit = true;
    }

    boolean isInit() {
        return this.isInit;
    }

    abstract boolean isFoundResource() throws IllegalStateException;

    String getResourcePath() throws IllegalStateException {
        if (this.isInit()) {
            return this.resourcePath;
        }
        throw new IllegalStateException("this Loader is not init.");
    }

    String getResourceName() throws IllegalStateException {
        if (this.isInit()) {
            return this.resourceName;
        }
        throw new IllegalStateException("this Loader is not init.");
    }

    String getFullName() throws IllegalStateException {
        return this.getResourcePath() + "." + this.getResourceName();
    }

    protected abstract Map[] parseResource() throws Exception;

    Set loadAll() throws Exception {
        HashSet<ConnectionPoolInfo> infos = new HashSet<ConnectionPoolInfo>();
        Map[] parseds = this.parseResource();
        int i = 0;
        while (i < parseds.length) {
            Map parsed = parseds[i];
            ConnectionPoolInfo info = new ConnectionPoolInfo();
            this.setValues(info, parsed);
            infos.add(info);
            ++i;
        }
        return infos;
    }

    private void setValues(ConnectionPoolInfo info, Map parsed) {
        HashSet<Method> methodSet = new HashSet<Method>(Arrays.asList(info.getClass().getMethods()));
        Iterator keys = parsed.keySet().iterator();
        block2: while (keys.hasNext()) {
            String lower;
            String key = (String)keys.next();
            Object val = parsed.get(key);
            String extKey = "";
            int index = key.indexOf(46);
            if (index == -1) {
                lower = key.toLowerCase();
            } else {
                lower = key.substring(0, index).toLowerCase();
                extKey = key.substring(++index);
            }
            String methodName = "set" + lower;
            Iterator methods = methodSet.iterator();
            while (methods.hasNext()) {
                Method m = (Method)methods.next();
                try {
                    Object conv;
                    if (!methodName.equals(m.getName().toLowerCase())) continue;
                    Class<?>[] types = m.getParameterTypes();
                    if (types.length == 1) {
                        conv = this.convert(types[0], val);
                        m.invoke((Object)info, conv);
                        methods.remove();
                        continue block2;
                    }
                    if (types.length != 2) continue;
                    conv = this.convert(types[1], val);
                    m.invoke((Object)info, extKey, conv);
                    continue block2;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException("invalid value found in babyPool's config file.\n  name = " + key + "\n" + "  value = " + val + "\n");
                }
            }
        }
    }

    private Object convert(Class cls, Object val) {
        Object ret = null;
        try {
            String str = val instanceof String ? (String)val : val.toString();
            if (cls.isPrimitive()) {
                if (cls == Byte.TYPE) {
                    ret = new Byte(str);
                } else if (cls == Double.TYPE) {
                    ret = new Double(str);
                } else if (cls == Float.TYPE) {
                    ret = new Float(str);
                } else if (cls == Integer.TYPE) {
                    ret = new Integer(str);
                } else if (cls == Long.TYPE) {
                    ret = new Long(str);
                }
            } else if (!cls.isArray()) {
                Constructor cnst = cls.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ConnectionPoolInfoLoader.class$("java.lang.String")) : class$java$lang$String);
                ret = cnst.newInstance(str);
            } else {
                ret = val;
            }
        }
        catch (Exception e) {
            ret = val;
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

