/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool.jdbc;

import java.lang.ref.WeakReference;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import java.util.Vector;
import jp.livewell.baby.pool.AbstractWrapper;
import jp.livewell.baby.pool.ComparisonKey;
import jp.livewell.baby.pool.jdbc.CallableStatementWrapper;
import jp.livewell.baby.pool.jdbc.PreparedStatementWrapper;
import jp.livewell.baby.pool.jdbc.StatementWrapper;

class ConnectionWrapper
extends AbstractWrapper
implements Connection {
    private Connection conn;
    private Connection closedConn;
    private DefaultValues defaults;
    private WeakReference ownRef;
    private String command;
    private long interval;
    private Vector statements = new Vector();
    private long lastAccess = System.currentTimeMillis();
    private boolean modAutoCommit = false;
    private boolean modCatalog = false;
    private boolean modReadOnly = false;
    private boolean modIsolation = false;
    private boolean modTypeMap = false;

    ConnectionWrapper(Connection conn, Connection closedConn, String command, long interval, DefaultValues defaults) throws SQLException, IllegalArgumentException {
        if (conn == null || closedConn == null || interval < 0L || defaults == null) {
            throw new IllegalArgumentException("please check values for create.\nconn = " + conn + "\n" + "closedConn = " + closedConn + "\n" + "command = " + command + "\n" + "interval = " + interval + "\n" + "defaults = " + defaults + "\n");
        }
        this.conn = conn;
        this.closedConn = closedConn;
        this.command = command;
        this.interval = interval;
        this.defaults = defaults;
        this.ownRef = new WeakReference<ConnectionWrapper>(this);
        this.ping();
    }

    public synchronized boolean passivate(ComparisonKey key) throws IllegalStateException {
        if (super.passivate(key)) {
            this.closeStatementsAll();
            boolean isReset = this.defaults.resetValues(this.conn, this.modAutoCommit, this.modCatalog, this.modReadOnly, this.modIsolation, this.modTypeMap);
            if (!isReset) {
                throw new IllegalStateException("can't reset values to default!");
            }
            this.modAutoCommit = false;
            this.modCatalog = false;
            this.modReadOnly = false;
            this.modIsolation = false;
            this.modTypeMap = false;
            return true;
        }
        return false;
    }

    public synchronized void destroy(ComparisonKey key) {
        super.destroy(key);
        try {
            try {
                try {
                    if (this.conn != null) {
                        this.conn.close();
                    }
                }
                catch (SQLException e) {
                }
                Object var4_4 = null;
                this.command = null;
                this.statements = null;
                this.conn = null;
                this.closedConn = null;
                this.ownRef = null;
            }
            catch (Exception e) {
                Object var4_5 = null;
                this.command = null;
                this.statements = null;
                this.conn = null;
                this.closedConn = null;
                this.ownRef = null;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.command = null;
            this.statements = null;
            this.conn = null;
            this.closedConn = null;
            this.ownRef = null;
            throw throwable;
        }
    }

    private void addStatement(Statement stmt) {
        if (stmt != null) {
            this.statements.add(stmt);
        }
    }

    private void closeStatementsAll() {
        int i = this.statements.size();
        while (i-- > 0) {
            Statement stmt = (Statement)this.statements.remove(i);
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private Connection connection() {
        return this.isWorkable() ? this.conn : this.closedConn;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean ping() {
        block13: {
            isSuccess = false;
            curr = System.currentTimeMillis();
            if (curr - this.lastAccess < this.interval) {
                isSuccess = true;
            } else {
                stmt = null;
                try {
                    stmt = this.conn.createStatement();
                    stmt.executeQuery(this.command);
                    isSuccess = true;
                    var7_4 = null;
                    ** if (stmt == null) goto lbl-1000
                }
                catch (Throwable var6_11) {
                    var7_6 = null;
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    throw var6_11;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block13;
                    catch (SQLException e) {
                        var7_5 = null;
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                }
            }
        }
        this.lastAccess = curr;
        return isSuccess;
    }

    public void clearWarnings() throws SQLException {
        this.connection().clearWarnings();
    }

    public void close() throws SQLException {
        if (this.isWorkable()) {
            this.release();
        } else {
            this.closedConn.close();
        }
    }

    public void commit() throws SQLException {
        this.connection().commit();
    }

    /*
     * WARNING - void declaration
     */
    public Statement createStatement() throws SQLException {
        try {
            void e;
            StatementWrapper stmt = new StatementWrapper(this.connection().createStatement(), this.ownRef);
            this.addStatement(stmt);
            return e;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            void e;
            StatementWrapper stmt = new StatementWrapper(this.connection().createStatement(resultSetType, resultSetConcurrency), this.ownRef);
            this.addStatement(stmt);
            return e;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e.toString());
        }
    }

    public String getCatalog() throws SQLException {
        return this.connection().getCatalog();
    }

    public boolean getAutoCommit() throws SQLException {
        return this.connection().getAutoCommit();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection().getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.connection().getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        return this.connection().getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.connection().getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return this.isWorkable() ? this.conn.isClosed() : true;
    }

    public boolean isReadOnly() throws SQLException {
        return this.connection().isReadOnly();
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.connection().nativeSQL(sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatementWrapper cstmt = new CallableStatementWrapper(this.connection().prepareCall(sql), this.ownRef);
        this.addStatement(cstmt);
        return cstmt;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatementWrapper cstmt = new CallableStatementWrapper(this.connection().prepareCall(sql, resultSetType, resultSetConcurrency), this.ownRef);
        this.addStatement(cstmt);
        return cstmt;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatementWrapper pstmt = new PreparedStatementWrapper(this.connection().prepareStatement(sql), this.ownRef);
        this.addStatement(pstmt);
        return pstmt;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatementWrapper pstmt = new PreparedStatementWrapper(this.connection().prepareStatement(sql, resultSetType, resultSetConcurrency), this.ownRef);
        this.addStatement(pstmt);
        return pstmt;
    }

    public void rollback() throws SQLException {
        this.connection().rollback();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection().setAutoCommit(autoCommit);
        this.modAutoCommit = this.defaults.checkAutoCommit(autoCommit);
    }

    public void setCatalog(String catalog) throws SQLException {
        this.connection().setCatalog(catalog);
        this.modCatalog = this.defaults.checkCatalog(catalog);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connection().setReadOnly(readOnly);
        this.modReadOnly = this.defaults.checkReadOnly(readOnly);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.connection().setTransactionIsolation(level);
        this.modIsolation = this.defaults.checkTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.connection().setTypeMap(map);
        this.modTypeMap = this.defaults.checkTypeMap(map);
    }

    static class DefaultValues {
        private final boolean autoCommit;
        private String catalog;
        private final boolean readOnly;
        private final int isolation;
        private final Map typeMap;

        DefaultValues(Connection conn) throws SQLException {
            this.autoCommit = conn.getAutoCommit();
            this.catalog = conn.getCatalog();
            this.readOnly = conn.isReadOnly();
            this.isolation = conn.getTransactionIsolation();
            this.typeMap = conn.getTypeMap();
        }

        /*
         * Loose catch block
         */
        boolean resetValues(Connection conn, boolean modAutoCommit, boolean modCatalog, boolean modReadOnly, boolean modIsolation, boolean modTypeMap) {
            boolean isSuccess;
            block14: {
                isSuccess = false;
                if (!conn.getAutoCommit()) {
                    conn.rollback();
                }
                if (modAutoCommit) {
                    conn.setAutoCommit(this.autoCommit);
                }
                if (modCatalog) {
                    conn.setCatalog(this.catalog);
                }
                if (modReadOnly) {
                    conn.setReadOnly(this.readOnly);
                }
                if (modIsolation) {
                    conn.setTransactionIsolation(this.isolation);
                }
                if (modTypeMap) {
                    conn.setTypeMap(this.typeMap);
                }
                isSuccess = true;
                Object var10_8 = null;
                try {
                    conn.clearWarnings();
                }
                catch (SQLException e2) {}
                break block14;
                {
                    catch (SQLException e) {
                        Object var10_9 = null;
                        try {
                            conn.clearWarnings();
                        }
                        catch (SQLException e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    try {
                        conn.clearWarnings();
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            return isSuccess;
        }

        boolean checkAutoCommit(boolean val) {
            return val == this.autoCommit;
        }

        boolean checkCatalog(String val) {
            if (val != null) {
                return val.equals(this.catalog);
            }
            return this.catalog == null;
        }

        boolean checkReadOnly(boolean val) {
            return val == this.readOnly;
        }

        boolean checkTransactionIsolation(int val) {
            return val == this.isolation;
        }

        boolean checkTypeMap(Map val) {
            if (val != null) {
                return val.equals(this.typeMap);
            }
            return this.typeMap == null;
        }

        public boolean equals(Object o) {
            if (o instanceof DefaultValues) {
                DefaultValues vals = (DefaultValues)o;
                return vals.checkAutoCommit(this.autoCommit) && vals.checkCatalog(this.catalog) && vals.checkReadOnly(this.readOnly) && vals.checkTransactionIsolation(this.isolation) && vals.checkTypeMap(this.typeMap);
            }
            return false;
        }

        public String toString() {
            return "autoCommit = " + this.autoCommit + "\n" + "catalog = " + this.catalog + "\n" + "readOnly = " + this.readOnly + "\n" + "transactionIsolation = " + this.isolation + "\n" + "typeMap = " + this.typeMap + "\n";
        }
    }
}

