/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import jp.livewell.baby.pool.jdbc.ConnectionPool;
import jp.livewell.baby.pool.jdbc.ResourceManager;

public class PoolDriver
implements Driver {
    private final ResourceManager manager = ResourceManager.getInstance();

    public boolean acceptsURL(String url) throws SQLException {
        return this.manager.isAvailableUrl(url);
    }

    public Connection connect(String url, Properties info) throws SQLException {
        ConnectionPool pool = this.manager.findPoolByBetter(url, info);
        if (pool != null) {
            return pool.getConnection(url, info);
        }
        return null;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            PoolDriver pd = new PoolDriver();
            DriverManager.registerDriver(pd);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.toString());
        }
    }
}

