/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool.jdbc;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import jp.livewell.baby.pool.jdbc.ConnectionFactory;
import jp.livewell.baby.pool.jdbc.ConnectionPool;
import jp.livewell.baby.pool.jdbc.ConnectionPoolInfo;
import jp.livewell.baby.pool.jdbc.ConnectionPoolInfoLoader;

class ResourceManager {
    private static ResourceManager single = null;
    private final ArrayList pools = new ArrayList();
    private final HashMap poolNameMap = new HashMap();
    static /* synthetic */ Class class$jp$livewell$baby$pool$jdbc$ResourceManager;

    static ResourceManager getInstance() throws RuntimeException {
        Class clazz = class$jp$livewell$baby$pool$jdbc$ResourceManager == null ? (class$jp$livewell$baby$pool$jdbc$ResourceManager = ResourceManager.class$("jp.livewell.baby.pool.jdbc.ResourceManager")) : class$jp$livewell$baby$pool$jdbc$ResourceManager;
        synchronized (clazz) {
            if (single == null) {
                single = new ResourceManager();
                try {
                    single.loadPoolAll();
                }
                catch (Exception e) {
                    throw new RuntimeException("loading pools fail.\n" + e);
                }
            }
            ResourceManager resourceManager = single;
            return resourceManager;
        }
    }

    private ResourceManager() {
    }

    ConnectionPool findPoolByName(String name) {
        return (ConnectionPool)this.poolNameMap.get(name);
    }

    ConnectionPool findPoolByBetter(String url, Properties info) throws SQLException {
        ConnectionPool pool = null;
        ArrayList pls = this.pools;
        int size = pls.size();
        int i = 0;
        while (i < size) {
            ConnectionPool pl = (ConnectionPool)pls.get(i);
            int available = pl.checkAvailable(url, info);
            if (available == 2) {
                pool = pl;
                break;
            }
            if (available == 1) {
                pool = pl;
            }
            ++i;
        }
        return pool;
    }

    boolean isAvailableUrl(String url) throws SQLException {
        boolean isAvailable = false;
        ArrayList pls = this.pools;
        int size = pls.size();
        int i = 0;
        while (i < size) {
            ConnectionPool pl = (ConnectionPool)pls.get(i);
            if (pl.checkAvailable(url) != 0) {
                isAvailable = true;
                break;
            }
            ++i;
        }
        return isAvailable;
    }

    void registerPool(ConnectionPool pool) throws IllegalArgumentException {
        if (pool != null) {
            String name = pool.getName();
            ResourceManager resourceManager = this;
            synchronized (resourceManager) {
                if (!this.poolNameMap.containsKey(name)) {
                    this.poolNameMap.put(name, pool);
                    this.pools.add(pool);
                    ConnectionFactory fac = (ConnectionFactory)pool.getFactory();
                    try {
                        DriverManager.deregisterDriver(fac.getDriver());
                    }
                    catch (SQLException e) {}
                } else {
                    throw new IllegalArgumentException("already registed this ConnectionPool. name = " + name + ".\n");
                }
            }
        } else {
            throw new IllegalArgumentException("can't regist null to ResourceManager.");
        }
    }

    ConnectionPool deregisterPool(String name) {
        ConnectionPool pool = null;
        ResourceManager resourceManager = this;
        synchronized (resourceManager) {
            if (this.poolNameMap.containsKey(name)) {
                pool = (ConnectionPool)this.poolNameMap.remove(name);
                while (((AbstractCollection)this.pools).remove(pool)) {
                }
                ConnectionFactory fac = (ConnectionFactory)pool.getFactory();
                Driver drv = fac.getDriver();
                if (this.findDriverByName(drv.getClass().getName()) == null) {
                    try {
                        DriverManager.registerDriver(drv);
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
        }
        return pool;
    }

    Set poolNameSet() {
        return new HashSet(this.poolNameMap.keySet());
    }

    Driver findDriverByName(String className) {
        Driver drv = null;
        Iterator itr = this.poolNameMap.values().iterator();
        while (itr.hasNext()) {
            ConnectionPool pool = (ConnectionPool)itr.next();
            Driver d = ((ConnectionFactory)pool.getFactory()).getDriver();
            if (!d.getClass().getName().equals(className)) continue;
            drv = d;
            break;
        }
        return drv;
    }

    private void loadPoolAll() throws Exception {
        ConnectionPoolInfoLoader loader = ConnectionPoolInfoLoader.createInstance();
        Set infos = loader.loadAll();
        Iterator itr = infos.iterator();
        while (itr.hasNext()) {
            ConnectionPoolInfo info = (ConnectionPoolInfo)itr.next();
            ConnectionPool pool = new ConnectionPool(info);
            this.registerPool(pool);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

