/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.pool.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import jp.livewell.baby.pool.AbstractWrapper;
import jp.livewell.baby.pool.ComparisonKey;

class ResultSetWrapper
extends AbstractWrapper
implements ResultSet {
    private ResultSet result;
    private WeakReference stmtRef;

    ResultSetWrapper(ResultSet result, WeakReference stmtRef) throws IllegalArgumentException {
        if (result != null && stmtRef != null) {
            if (!(stmtRef.get() instanceof Statement)) {
                throw new IllegalArgumentException("need java.sql.Statement(or it's sub class) reference!");
            }
        } else {
            throw new IllegalArgumentException("please check params.\nresult = " + result + "\n" + "stmtRef = " + stmtRef + "\n");
        }
        this.result = result;
        this.stmtRef = stmtRef;
        this.activate(this.getComparisonKey());
    }

    public synchronized void destroy(ComparisonKey key) {
        try {
            block4: {
                try {
                    super.destroy(key);
                    if (this.result == null) break block4;
                    this.result.close();
                }
                catch (Exception e) {
                    Object var4_3 = null;
                    this.stmtRef = null;
                }
            }
            Object var4_2 = null;
            this.stmtRef = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.stmtRef = null;
            throw throwable;
        }
    }

    protected boolean ping() {
        return true;
    }

    private ResultSet resultSet() {
        return this.result;
    }

    public void close() throws SQLException {
        this.destroy(this.getComparisonKey());
    }

    public boolean absolute(int row) throws SQLException {
        return this.resultSet().absolute(row);
    }

    public void afterLast() throws SQLException {
        this.resultSet().afterLast();
    }

    public void beforeFirst() throws SQLException {
        this.resultSet().beforeFirst();
    }

    public void cancelRowUpdates() throws SQLException {
        this.resultSet().cancelRowUpdates();
    }

    public void clearWarnings() throws SQLException {
        this.resultSet().clearWarnings();
    }

    public void deleteRow() throws SQLException {
        this.resultSet().deleteRow();
    }

    public int findColumn(String name) throws SQLException {
        return this.resultSet().findColumn(name);
    }

    public boolean first() throws SQLException {
        return this.resultSet().first();
    }

    public int getConcurrency() throws SQLException {
        return this.resultSet().getConcurrency();
    }

    public String getCursorName() throws SQLException {
        return this.resultSet().getCursorName();
    }

    public int getFetchDirection() throws SQLException {
        return this.resultSet().getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.resultSet().getFetchSize();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSet().getMetaData();
    }

    public int getRow() throws SQLException {
        return this.resultSet().getRow();
    }

    public Statement getStatement() throws SQLException {
        return (Statement)this.stmtRef.get();
    }

    public int getType() throws SQLException {
        return this.resultSet().getType();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.resultSet().getWarnings();
    }

    public void insertRow() throws SQLException {
        this.resultSet().insertRow();
    }

    public boolean isAfterLast() throws SQLException {
        return this.resultSet().isAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.resultSet().isBeforeFirst();
    }

    public boolean isFirst() throws SQLException {
        return this.resultSet().isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.resultSet().isLast();
    }

    public boolean last() throws SQLException {
        return this.resultSet().last();
    }

    public void moveToCurrentRow() throws SQLException {
        this.resultSet().moveToCurrentRow();
    }

    public void moveToInsertRow() throws SQLException {
        this.resultSet().moveToInsertRow();
    }

    public boolean next() throws SQLException {
        return this.resultSet().next();
    }

    public boolean previous() throws SQLException {
        return this.resultSet().previous();
    }

    public void refreshRow() throws SQLException {
        this.resultSet().refreshRow();
    }

    public boolean relative(int rows) throws SQLException {
        return this.resultSet().relative(rows);
    }

    public boolean rowDeleted() throws SQLException {
        return this.resultSet().rowDeleted();
    }

    public boolean rowInserted() throws SQLException {
        return this.resultSet().rowInserted();
    }

    public boolean rowUpdated() throws SQLException {
        return this.resultSet().rowUpdated();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.resultSet().setFetchDirection(direction);
    }

    public void setFetchSize(int size) throws SQLException {
        this.resultSet().setFetchSize(size);
    }

    public void updateRow() throws SQLException {
        this.resultSet().updateRow();
    }

    public Array getArray(int index) throws SQLException {
        return this.resultSet().getArray(index);
    }

    public Array getArray(String name) throws SQLException {
        return this.resultSet().getArray(name);
    }

    public InputStream getAsciiStream(int index) throws SQLException {
        return this.resultSet().getAsciiStream(index);
    }

    public InputStream getAsciiStream(String name) throws SQLException {
        return this.resultSet().getAsciiStream(name);
    }

    public void updateAsciiStream(int index, InputStream val, int length) throws SQLException {
        this.resultSet().updateAsciiStream(index, val, length);
    }

    public void updateAsciiStream(String name, InputStream val, int length) throws SQLException {
        this.resultSet().updateAsciiStream(name, val, length);
    }

    public InputStream getBinaryStream(int index) throws SQLException {
        return this.resultSet().getBinaryStream(index);
    }

    public InputStream getBinaryStream(String name) throws SQLException {
        return this.resultSet().getBinaryStream(name);
    }

    public void updateBinaryStream(int index, InputStream val, int length) throws SQLException {
        this.resultSet().updateBinaryStream(index, val, length);
    }

    public void updateBinaryStream(String name, InputStream val, int length) throws SQLException {
        this.resultSet().updateBinaryStream(name, val, length);
    }

    public BigDecimal getBigDecimal(int index) throws SQLException {
        return this.resultSet().getBigDecimal(index);
    }

    public BigDecimal getBigDecimal(String name) throws SQLException {
        return this.resultSet().getBigDecimal(name);
    }

    public BigDecimal getBigDecimal(int index, int scale) throws SQLException {
        return this.resultSet().getBigDecimal(index, scale);
    }

    public BigDecimal getBigDecimal(String name, int scale) throws SQLException {
        return this.resultSet().getBigDecimal(name, scale);
    }

    public void updateBigDecimal(int index, BigDecimal val) throws SQLException {
        this.resultSet().updateBigDecimal(index, val);
    }

    public void updateBigDecimal(String name, BigDecimal val) throws SQLException {
        this.resultSet().updateBigDecimal(name, val);
    }

    public Blob getBlob(int index) throws SQLException {
        return this.resultSet().getBlob(index);
    }

    public Blob getBlob(String name) throws SQLException {
        return this.resultSet().getBlob(name);
    }

    public boolean getBoolean(int index) throws SQLException {
        return this.resultSet().getBoolean(index);
    }

    public boolean getBoolean(String name) throws SQLException {
        return this.resultSet().getBoolean(name);
    }

    public void updateBoolean(int index, boolean val) throws SQLException {
        this.resultSet().updateBoolean(index, val);
    }

    public void updateBoolean(String name, boolean val) throws SQLException {
        this.resultSet().updateBoolean(name, val);
    }

    public byte getByte(int index) throws SQLException {
        return this.resultSet().getByte(index);
    }

    public byte getByte(String name) throws SQLException {
        return this.resultSet().getByte(name);
    }

    public void updateByte(int index, byte val) throws SQLException {
        this.resultSet().updateByte(index, val);
    }

    public void updateByte(String name, byte val) throws SQLException {
        this.resultSet().updateByte(name, val);
    }

    public byte[] getBytes(int index) throws SQLException {
        return this.resultSet().getBytes(index);
    }

    public byte[] getBytes(String name) throws SQLException {
        return this.resultSet().getBytes(name);
    }

    public void updateBytes(int index, byte[] val) throws SQLException {
        this.resultSet().updateBytes(index, val);
    }

    public void updateBytes(String name, byte[] val) throws SQLException {
        this.resultSet().updateBytes(name, val);
    }

    public Reader getCharacterStream(int index) throws SQLException {
        return this.resultSet().getCharacterStream(index);
    }

    public Reader getCharacterStream(String name) throws SQLException {
        return this.resultSet().getCharacterStream(name);
    }

    public void updateCharacterStream(int index, Reader reader, int length) throws SQLException {
        this.resultSet().updateCharacterStream(index, reader, length);
    }

    public void updateCharacterStream(String name, Reader reader, int length) throws SQLException {
        this.resultSet().updateCharacterStream(name, reader, length);
    }

    public Clob getClob(int index) throws SQLException {
        return this.resultSet().getClob(index);
    }

    public Clob getClob(String name) throws SQLException {
        return this.resultSet().getClob(name);
    }

    public Date getDate(int index) throws SQLException {
        return this.resultSet().getDate(index);
    }

    public Date getDate(String name) throws SQLException {
        return this.resultSet().getDate(name);
    }

    public Date getDate(int index, Calendar cal) throws SQLException {
        return this.resultSet().getDate(index, cal);
    }

    public Date getDate(String name, Calendar cal) throws SQLException {
        return this.resultSet().getDate(name, cal);
    }

    public void updateDate(int index, Date val) throws SQLException {
        this.resultSet().updateDate(index, val);
    }

    public void updateDate(String name, Date val) throws SQLException {
        this.resultSet().updateDate(name, val);
    }

    public double getDouble(int index) throws SQLException {
        return this.resultSet().getDouble(index);
    }

    public double getDouble(String name) throws SQLException {
        return this.resultSet().getDouble(name);
    }

    public void updateDouble(int index, double val) throws SQLException {
        this.resultSet().updateDouble(index, val);
    }

    public void updateDouble(String name, double val) throws SQLException {
        this.resultSet().updateDouble(name, val);
    }

    public float getFloat(int index) throws SQLException {
        return this.resultSet().getFloat(index);
    }

    public float getFloat(String name) throws SQLException {
        return this.resultSet().getFloat(name);
    }

    public void updateFloat(int index, float val) throws SQLException {
        this.resultSet().updateFloat(index, val);
    }

    public void updateFloat(String name, float val) throws SQLException {
        this.resultSet().updateFloat(name, val);
    }

    public int getInt(int index) throws SQLException {
        return this.resultSet().getInt(index);
    }

    public int getInt(String name) throws SQLException {
        return this.resultSet().getInt(name);
    }

    public void updateInt(int index, int val) throws SQLException {
        this.resultSet().updateInt(index, val);
    }

    public void updateInt(String name, int val) throws SQLException {
        this.resultSet().updateInt(name, val);
    }

    public long getLong(int index) throws SQLException {
        return this.resultSet().getLong(index);
    }

    public long getLong(String name) throws SQLException {
        return this.resultSet().getLong(name);
    }

    public void updateLong(int index, long val) throws SQLException {
        this.resultSet().updateLong(index, val);
    }

    public void updateLong(String name, long val) throws SQLException {
        this.resultSet().updateLong(name, val);
    }

    public void updateNull(int index) throws SQLException {
        this.resultSet().updateNull(index);
    }

    public void updateNull(String name) throws SQLException {
        this.resultSet().updateNull(name);
    }

    public Object getObject(int index) throws SQLException {
        return this.resultSet().getObject(index);
    }

    public Object getObject(String name) throws SQLException {
        return this.resultSet().getObject(name);
    }

    public Object getObject(int index, Map map) throws SQLException {
        return this.resultSet().getObject(index, map);
    }

    public Object getObject(String name, Map map) throws SQLException {
        return this.resultSet().getObject(name, map);
    }

    public void updateObject(int index, Object val) throws SQLException {
        this.resultSet().updateObject(index, val);
    }

    public void updateObject(String name, Object val) throws SQLException {
        this.resultSet().updateObject(name, val);
    }

    public void updateObject(int index, Object val, int scale) throws SQLException {
        this.resultSet().updateObject(index, val, scale);
    }

    public void updateObject(String name, Object val, int scale) throws SQLException {
        this.resultSet().updateObject(name, val, scale);
    }

    public Ref getRef(int index) throws SQLException {
        return this.resultSet().getRef(index);
    }

    public Ref getRef(String name) throws SQLException {
        return this.resultSet().getRef(name);
    }

    public short getShort(int index) throws SQLException {
        return this.resultSet().getShort(index);
    }

    public short getShort(String name) throws SQLException {
        return this.resultSet().getShort(name);
    }

    public void updateShort(int index, short val) throws SQLException {
        this.resultSet().updateShort(index, val);
    }

    public void updateShort(String name, short val) throws SQLException {
        this.resultSet().updateShort(name, val);
    }

    public String getString(int index) throws SQLException {
        return this.resultSet().getString(index);
    }

    public String getString(String name) throws SQLException {
        return this.resultSet().getString(name);
    }

    public void updateString(int index, String val) throws SQLException {
        this.resultSet().updateString(index, val);
    }

    public void updateString(String name, String val) throws SQLException {
        this.resultSet().updateString(name, val);
    }

    public Time getTime(int index) throws SQLException {
        return this.resultSet().getTime(index);
    }

    public Time getTime(String name) throws SQLException {
        return this.resultSet().getTime(name);
    }

    public Time getTime(int index, Calendar cal) throws SQLException {
        return this.resultSet().getTime(index, cal);
    }

    public Time getTime(String name, Calendar cal) throws SQLException {
        return this.resultSet().getTime(name, cal);
    }

    public void updateTime(int index, Time val) throws SQLException {
        this.resultSet().updateTime(index, val);
    }

    public void updateTime(String name, Time val) throws SQLException {
        this.resultSet().updateTime(name, val);
    }

    public Timestamp getTimestamp(int index) throws SQLException {
        return this.resultSet().getTimestamp(index);
    }

    public Timestamp getTimestamp(String name) throws SQLException {
        return this.resultSet().getTimestamp(name);
    }

    public Timestamp getTimestamp(int index, Calendar cal) throws SQLException {
        return this.resultSet().getTimestamp(index, cal);
    }

    public Timestamp getTimestamp(String name, Calendar cal) throws SQLException {
        return this.resultSet().getTimestamp(name, cal);
    }

    public void updateTimestamp(int index, Timestamp val) throws SQLException {
        this.resultSet().updateTimestamp(index, val);
    }

    public void updateTimestamp(String name, Timestamp val) throws SQLException {
        this.resultSet().updateTimestamp(name, val);
    }

    public InputStream getUnicodeStream(int index) throws SQLException {
        return this.resultSet().getUnicodeStream(index);
    }

    public InputStream getUnicodeStream(String name) throws SQLException {
        return this.resultSet().getUnicodeStream(name);
    }

    public boolean wasNull() throws SQLException {
        return this.resultSet().wasNull();
    }
}

